## Contributing to Condenser

Everyone is welcome to contribute code to Steemit, Inc. projects. We have a Code of Conduct; we ask that you please follow it in all your interactions with our team and your fellow contributors.

### How to contribute

1. File a Github issue describing the problem you would like to solve or the feature you would like to add. It saves unnecessary work on your part, in case there's a nontechnical reason we can't accept a particular change. 
2. Learn the conventions of the project you are submitting code to, even implicit ones, and follow them. In case you have a question about a project's conventions, please ask on the issue you filed. This includes writing tests, formatting code, and documentation. 
3. File a pull request against your Github issue and fill out the pull request template. Remember, you are agreeing to license your code and any intellectual property associated with your code under the same terms as the repository you are contributing to. Please note that we can and will automatically close all pull requests that do not refer to an issue. 
4. If one of our teammates asks you to make changes, please make them. Our rule is that all requests for changes in code review are resolved in favor of the reviewer. Our teammates follow this rule too! 
5. **Reporting Bugs**: If there is an existing feature that is not working correctly, or a glitch in the website that is impacting user behavior, please file an issue to report it. Bug reports must include, at a minimum, the following information:- the environment in which you encountered the bug. In the case of a Web application, this includes the URL, date and time of access, the name and version of the operating system and browser you’re using. In the case of a client library or other program, this includes a full stack trace as well as a representative example of the triggering code.
6. **Enhancement Suggestions**: If you have an enhancement you would like to see in Condenser, file it as an issue in this repo. Be clear in describing what problem you are trying to solve or enhancement to existing functionality you’d like to see. Our team will review your issue and offer feedback, accept it for internal development or recommend community development. 
7. **Development Discussions**: The developers frequently open issues to discuss changes that are being worked on. This is to inform the community of the changes being worked on, and to get input from the community and other developers on the implementation. 
8. **Pull Requests**: We love community contributions. If you've done some work on an issue and want to see it in the Condenser codebase, please submit a Pull Request, reference the issue in the description and start the title with `community -`. We're working very hard to keep our development practices as open as possible, and this helps us a lot. 
9. **Translations**: Becoming a translator for your native language is easy and a great help to users around the world. To add your native language contributions for an existing or new language, please email [translate@steemit.com](mailto:translate@steemit.com) to receive your email invite. Translators are able to join existing translated languages or submit a new language. Please do not submit Pull Requests with your updates, all key string updates should always be added first in our translations platform. 

## Code of Conduct

Again, please note that this Code of Conduct only applies to our development presence.

### Our Pledge

We welcome your membership in our project and community under the rules that we have set below.

In the interest of fostering an open and welcoming environment, we as contributors and maintainers will work to make your participation in our project and community as fulfilling as possible.

### Our Rules

All members of our project and community must:

1. Show empathy toward other project and community members 
2. Use welcoming and inclusive language 
3. Respect differing viewpoints and experiences 
4. Gracefully accept constructive criticism 

All members of our project and community must not:

1. Harm our project and community, or advocate harm to our project and community 
2. Insult or make derogatory comments about others 
3. Interact with others after they have withdrawn permission to do so 

### Our Responsibilities

We will use any and all lawful means at our disposal to enforce our rules. This includes but is not limited to:

1. Rejecting contributions 
2. Removing comments, commits, code, wiki edits, and issues 
3. Banning abusers 

We will clarify standards of acceptable behavior and we will take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting us at github.abuse@steemit.com. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. We maintain strict confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org/), version 1.4, available at [http://contributor-covenant.org/version/1/4](http://contributor-covenant.org/version/1/4/gg)
