import React from 'react';

class Privacy extends React.Component {
    render() {
        return (
            <div className="Privacy row">
                <div className="column large-12">
                    <h1>Steemit, Inc Privacy Policy</h1>
                    <div>
                        <h2>Effective April 1, 2016</h2>
                        <p>
                            <span className="section">1</span>
                            We want you to understand how and why Steemit, Inc (“Steemit,” “we” or “us”) collects, uses, and shares information about you when
                            you access and use Steemit’s websites, mobile apps, widgets, and other online products and services (collectively, the "Services")
                            or when you otherwise interact with us.
                        </p>
                    </div>
                    <div>
                        <h2>Information You Provide to Us</h2>
                        <p>
                            <span className="section">2</span>
                            We collect information you provide directly to us when you use our Services. Depending on which Service you use, we may collect
                            different information about you. This includes:
                        </p>
                    </div>
                    <div>
                        <h4>Information Regarding Your Use of the Services</h4>
                        <p>
                            <span className="section">3</span>
                            We collect the content and other information you provide when you use our Services. This includes information used to create your
                            account (e.g., a username, an email address, phone number), account preferences, and the content of information you post to the
                            Services (e.g., text, photos, videos, links).
                        </p>
                    </div>
                    <div>
                        <h4>Transactional Information</h4>
                        <p>
                            <span className="section">4</span>
                            If you purchase products or services from us (e.g., Steem Power), we will collect certain information from you, including your name,
                            address, email address, and information about the product or service you are purchasing. Payments are processed by third-party
                            payment processors (e.g., Stripe and PayPal), so please refer to the applicable processor’s terms and privacy policy for more
                            information about how payment information is processed and stored.
                        </p>
                    </div>
                    <div>
                        <h2>Other Information</h2>
                        <p>
                            <span className="section">5</span>
                            You may choose to provide other information directly to us. For example, we may collect information when you fill out a form,
                            participate in contests, sweepstakes or promotions, apply for a job, communicate with us via third-party sites and services, request
                            customer support or otherwise communicate with us.
                        </p>
                    </div>
                    <div>
                        <h2>Information We Collect Automatically</h2>
                        <p>
                            <span className="section">6</span>
                            When you access or use our Services, we may also automatically collect information about you. This includes:
                        </p>
                    </div>
                    <div>
                        <h4>Log and Usage Data</h4>
                        <p>
                            <span className="section">7</span>
                            We may log information when you access and use the Services. This may include your IP address, user-agent string, browser type,
                            operating system, referral URLs, device information (e.g., device IDs), pages visited, links clicked, user interactions (e.g.,
                            voting data), the requested URL, hardware settings, and search terms.
                        </p>
                    </div>
                    <div>
                        <h4>Information Collected from Cookies</h4>
                        <p>
                            <span className="section">8</span>
                            We may receive information from cookies, which are pieces of data your browser stores and sends back to us when making requests. We
                            use this information to improve your experience, understand user activity, and improve the quality of our Services. For
                            example, we store and retrieve information about your preferred language and other settings. For more information on how you can
                            disable cookies, please see “Your Choices” below.
                        </p>
                    </div>
                    <div>
                        <h4>Location Information</h4>
                        <p>
                            <span className="section">9</span>
                            With your consent, we may collect information about the specific location of your mobile device (for example, by using GPS or
                            Bluetooth). You can revoke this consent at any time by changing the preferences on your device, but doing so may affect your ability
                            to use all of the features and functionality of our Services.
                        </p>
                    </div>
                    <div>
                        <h2>Social Sharing</h2>
                        <p>
                            <span className="section">10</span>
                            We may offer social sharing features or other integrated tools that let you share content or actions you take on our Services with
                            other media. Your use of these features enables the sharing of certain information with your friends or the public, depending on the
                            settings you establish with the third party that provides the social sharing feature. For more information about the purpose and
                            scope of data collection and processing in connection with social sharing features, please visit the privacy policies of the third
                            parties that provide these social sharing features (e.g., Tumblr, Facebook, Reddit, Pinterest, and Twitter).
                        </p>
                    </div>
                    <div>
                        <h2>How We Use Information About You</h2>
                        <div>
                            <span className="section">11</span>
                            We use information about you to:
                            <ul>
                                <li>Provide, maintain, and improve the Services;</li>
                                <li>Help protect the safety of Steemit and our users, which includes blocking suspected spammers, addressing abuse, and
                                    enforcing the Steemit user agreement and the Terms of Service;
                                </li>
                                <li>Send you technical notices, updates, security alerts, invoices and other support and administrative messages;</li>
                                <li>Provide customer service;</li>
                                <li>Communicate with you about products, services, offers, promotions, and events, and provide other news and information we
                                    think will be of interest to you (for information about how to opt out of these communications, see “Your Choices” below);
                                </li>
                                <li>Monitor and analyze trends, usage, and activities in connection with our Services;</li>
                                <li>Personalize the Services and provide advertisements, content and features that match user profiles or interests.</li>
                            </ul>
                        </div>
                    </div>
                    <div>
                        <h2>How We Share Information</h2>
                        <div>
                            <span className="section">12</span>
                            When you use the Services, certain information may be shared with other users and the public. For example:
                            <ul>
                                <li>When you submit a post or comment to the Services, visitors to and users of our Services will be able to see the content of
                                    your posts and comments, the username associated with your posts or comments, and the date and time you originally submitted
                                    the post or comment. Although some parts of the Services may be private or quarantined, they may become public and you
                                    should take that into consideration before posting to the Services.
                                </li>
                                <li>When other users view your profile, they will be able to see information about your activities on the Services, such as your
                                    username, prior posts and comments, Steem Power, and how long you have been a member of the Services.
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div>
                        <p>
                            <span className="section">13</span>
                            Please note that, even when you delete your account, the posts, comments and messages you submit through the Services may still be
                            viewable or available on our servers. For more information, see “Your Choices” below.
                        </p>
                    </div>
                    <div>
                        <div>
                            <span className="section">14</span>
                            We will not share, sell, or give away any of our users’ personal information to third parties, unless one of the following
                            circumstances applies:
                            <ul>
                                <li>Except as it relates to advertisers and our ad partners, we may share information with vendors, consultants, and other
                                    service providers who need access to such information to carry out work for us;
                                </li>
                                <li>If you participate in contests, sweepstakes, promotions, special offers, or other events or activities in connection with
                                    our Services, we may share information with entities that partner with us to provide these offerings;
                                </li>
                                <li>We may share information (and will attempt to provide you with prior notice, to the extent legally permissible) in response
                                    to a request for information if we believe disclosure is in accordance with, or required by, any applicable law, regulation,
                                    legal process or governmental request;
                                </li>
                                <li>We may share information in response to an emergency if we believe it's necessary to prevent imminent and serious bodily
                                    harm to a person;
                                </li>
                                <li>We may share information if we believe your actions are inconsistent with our user agreements, or other Steemit policies, or
                                    to protect the rights, property, and safety of ourselves and others;
                                </li>
                                <li>We may share information between and among Steemit, and its current and future parents, affiliates, subsidiaries, and other
                                    companies under common control and ownership; and
                                </li>
                                <li>We may share information with your consent or at your direction.</li>
                            </ul>
                        </div>
                    </div>
                    <div>
                        <p>
                            <span className="section">15</span>
                            We may share aggregated or de-identified information, which cannot reasonably be used to identify you.
                        </p>
                    </div>
                    <div>
                        <h2>Ads and Analytics Partners</h2>
                        <p>
                            <span className="section">16</span>
                            We may partner with third-party advertisers, ad networks, and analytics providers to deliver advertising and content targeted to
                            your interests and to better understand your use of the Services. These third parties may collect information sent by your computer,
                            browser, or mobile device in response to a request for content, such as unique identifiers, your IP address, or other information
                            about your computer or device. For example:
                        </p>
                    </div>
                    <div>
                        <h4>Advertisers and Ad Networks</h4>
                        <p>
                            <span className="section">17</span>
                            Our ad partners and network may use cookies and use related technologies to collect information when ads are delivered to you on our
                            Services, but Steemit does not link to or provide your actual Steemit account details to these advertising partners. This means that
                            Steemit does not share your individual account browsing habits with advertisers. Steemit cannot see advertisers’ cookies and
                            advertisers will not see Steemit cookies.
                        </p>
                    </div>
                    <div>
                        <h4>Analytics Partners</h4>
                        <p>
                            <span className="section">18</span>
                            We use analytics partners (such as Google Analytics) to help analyze usage and traffic for our Services. As an example, we may use
                            analytics partners to analyze and measure, in the aggregate, the number of unique visitors to our Services.
                        </p>
                    </div>
                    <div>
                        <p>
                            <span className="section">19</span>
                            For more information about how you may control the collection and/or use of information for advertising and analytics purposes,
                            please see “Your Choices.”
                        </p>
                    </div>
                    <div>
                        <h2>Security</h2>
                        <p>
                            <span className="section">20</span>
                            We take reasonable measures to help protect information about you from loss, theft, misuse and unauthorized access, disclosure,
                            alteration, and destruction.
                        </p>
                    </div>
                    <div>
                        <h2>Children under 13</h2>
                        <p>
                            <span className="section">21</span>
                            Although we welcome users from all walks of life, Steemit is not intended or directed at individuals under the age of 13. Therefore,
                            individuals under the age of 13 may not create an account or otherwise access or use the Services.
                        </p>
                    </div>
                    <div>
                        <h2>Your Choices</h2>
                        <p>
                            <span className="section">22</span>
                            As a Steemit user, you have choices about how to protect and limit the collection, use, and disclosure of, information about you.
                            This includes:
                        </p>
                    </div>
                    <div>
                        <h4>Preferences</h4>
                        <p>
                            <span className="section">23</span>
                            We may provide you with tools and preference settings that allow you to access, correct, delete, and modify information associated
                            with your account.
                        </p>
                    </div>
                    <div>
                        <h4>Account Information</h4>
                        <p>
                            <span className="section">24</span>
                            You may delete your account information at any time by logging into your account and following the steps under “Preferences.” When
                            you delete your account, your profile is no longer visible to other users and disassociated from content you posted under that
                            account. Please note, however, that the posts, comments, and messages you submitted prior to deleting your account will still be
                            visible to others, unless you delete such content. We may also retain certain information about you as required by law or for
                            legitimate business purposes after you delete your account. Any information that has been published to the Steem blockchain will
                            also remain indefinitely.
                        </p>
                    </div>
                    <div>
                        <h4>Cookies</h4>
                        <p>
                            <span className="section">25</span>
                            Most web browsers are set to accept cookies by default. If you prefer, you can usually choose to set your browser to remove or
                            reject first- and third-party cookies. Please note that if you choose to remove or reject cookies, this could affect the
                            availability and functionality of our Services.
                        </p>
                    </div>
                    <div>
                        <h4>Third-Party Advertising and Analytics</h4>
                        <p>
                            <span className="section">26</span>
                            Some analytics providers may provide specific opt-out mechanisms (e.g. Google Analytics Opt-out), and we will provide, as needed,
                            additional tools and third-party services that allow you to better understand cookies and how you can opt-out. You have the ability
                            to opt out of having your web browsing information used for
                            behavioral advertising purposes. For more information about behavioral advertising, or to opt out, please visit
                            www.aboutads.info/choices.
                        </p>
                    </div>
                    <div>
                        <h4>Do Not Track</h4>
                        <p>
                            <span className="section">27</span>
                            Do Not Track (“DNT”) is a privacy preference that you can set in most web browsers. We support DNT in our Services. There is no
                            accepted standard on how to respond to web browsers’ DNT signals. When you have DNT enabled, we may still use information collected
                            for analytics and measurement purposes or to otherwise provide our Services (e.g., Steemit.com buttons), but we will not load any
                            third-party trackers. You may, however, opt out of having information about you collected and used for behavioral advertising
                            purposes, as described above.
                        </p>
                    </div>
                    <div>
                        <h4>Promotional Communications</h4>
                        <p>
                            <span className="section">28</span>
                            You may opt out of receiving promotional communications from us by following the instructions in those communications. If you opt
                            out, we may still send you non-promotional communications, such as information about your account or your use of our Services.
                        </p>
                    </div>
                    <div>
                        <h4>Mobile Notifications</h4>
                        <p>
                            <span className="section">29</span>
                            With your consent, we may send promotional and non-promotional push notifications or alerts to your mobile device. You can
                            deactivate these messages at any time by changing the notification settings on your mobile device.
                        </p>
                    </div>
                    <div>
                        <h2>International Data Transfers</h2>
                        <p>
                            <span className="section">30</span>
                            We are based in the United States and the information we collect is governed by U.S. law. By accessing or using the Services or
                            otherwise providing information to us, you consent to the processing, transfer and storage of information in and to the U.S. and
                            other countries, where you may not have the same rights as you do under local law.
                        </p>
                    </div>
                    <div>
                        <p>
                            <span className="section">31</span>
                            Steemit complies with the U.S.-E.U. and U.S.-Swiss Safe Harbor Privacy Principles of notice, choice, onward transfer, security, data
                            integrity, access, and enforcement. Despite an adverse judgment by the European Court of Justice on October 6, 2015, the U.S.
                            Department of Commerce has advised that it continues to administer the Safe Harbor program until further notice. To learn more about
                            the Safe Harbor program, and to view our certification, please visit the U.S. Department of Commerce website. If you have concerns
                            about our compliance with the Safe Harbor program, you should contact us. If you are unable to resolve your concern or dispute with
                            us, you may submit complaints to JAMS for mediation pursuant to the JAMS International Mediation Rules.
                        </p>
                    </div>
                    <div>
                        <h2>Changes</h2>
                        <p>
                            <span className="section">32</span>
                            We may change this Privacy Policy from time to time. If we do, we will let you know by revising the date at the top of the policy.
                            If we make a change to this policy that, in our sole discretion, is material, we will provide you with additional notice (such as
                            adding a statement to steemouncements, the front page of the Services or sending you a notification). We encourage you to review the
                            Privacy Policy whenever you access or use our Services or otherwise interact with us to stay informed about our information
                            practices and the ways you can help protect your privacy. If you continue to use our Services after Privacy Policy changes go into
                            effect, you consent to the revised policy.
                        </p>
                    </div>
                    <div>
                        <h2>Contact Us</h2>
                        <p>
                            <span className="section">33</span>
                            If you have any questions about this Privacy Policy, please email <a href="mailto:contact@steemit.com">contact@steemit.com</a>.
                        </p>
                    </div>
                </div>
            </div>
        );
    }
}

module.exports = {
    path: 'privacy.html',
    component: Privacy
};
