# Steemit FAQ 

<a class="anchor" name="Table_of_Contents"></a>
## Table of Contents

<a class="anchor" name="Table_of_Contents_General"></a>
### General
- <a href="/faq.html#What_is_Steemit_com">What is Steemit.com?</a>
- <a href="/faq.html#How_does_Steemit_work">How does Steemit work?</a>
- <a href="/faq.html#How_does_Steemit_differ_from_other_social_media_websites">How does Steemit differ from other social media websites?</a>
- <a href="/faq.html#Does_it_cost_anything_to_post__comment__or_vote">Does it cost anything to post, comment, or vote?</a>
- <a href="/faq.html#Can_I_earn_digital_tokens_on_Steemit_How">Can I earn digital tokens on Steemit? How?</a>
- <a href="/faq.html#Where_do_the_tokens_come_from">Where do the tokens come from?</a>
- <a href="/faq.html#Where_does_the_value_come_from">Where does the value come from?</a>
- <a href="/faq.html#Why_are_people_getting_vastly_different_rewards">Why are people getting vastly different rewards?</a>

<a class="anchor" name="Table_of_Contents_Accounts"></a>
### Accounts
- <a href="/faq.html#How_do_I_create_an_account">How do I create an account?</a>
- <a href="/faq.html#What_information_do_I_need_to_provide_in_order_to_create_an_account">What information do I need to provide in order to create an account?</a>
- <a href="/faq.html#How_long_does_the_account_approval_process_take">How long does the account approval process take?</a>
- <a href="/faq.html#Why_do_I_need_to_provide_my_email_and_phone_number">Why do I need to provide my email and phone number?</a>
- <a href="/faq.html#Can_I_create_a_Steem_account_without_an_email_and_phone_number">Can I create a Steem account without an email and phone number?</a>
- <a href="/faq.html#What_are_other_ways_to_create_an_account_on_the_blockchain_besides_using_Steemit_com">What are other ways to create an account on the blockchain besides using Steemit.com?</a>
- <a href="/faq.html#It_is_not_letting_me_create_an_account_with_my_phone_number__What_should_I_do">It is not letting me create an account with my phone number. What should I do?</a>
- <a href="/faq.html#What_happens_if_my_email_or_phone_number_changes">What happens if my email or phone number changes?</a>
- <a href="/faq.html#Am_I_allowed_to_create_more_than_one_account">Am I allowed to create more than one account</a>
- <a href="/faq.html#Can_I_delete_or_deactivate_my_account">Can I delete or deactivate my account?</a>

### Community
- <a href="/faq.html#Is_there_an_Etiquette_Guide_for_Steemit">Is there an Etiquette Guide for Steemit?</a>
- <a href="/faq.html#Am_I_required_to_verify_my_identity">Am I required to verify my identity?</a>

<a class="anchor" name="Table_of_Contents_Site_Navigation"></a>
### Site Navigation
- <a href="/faq.html#How_do_I_upvote_a_post_or_comment">How do I upvote a post or comment?</a>
- <a href="/faq.html#What_do_the_Home__New__Hot__Trending__and_Promoted_links_show">What do the Home, New, Hot, Trending, and Promoted links show?</a>
- <a href="/faq.html#What_information_is_available_in_my_account_menu">What information is available in my account menu?</a>
- <a href="/faq.html#How_do_I_see_my_recent_rewards">How do I see my recent rewards?</a>
- <a href="/faq.html#What_information_is_shown_in_my_wallet">What information is shown in my wallet?</a>
- <a href="/faq.html#How_do_I_transfer_my_STEEM_or_Steem_Dollars_into_savings">How do I transfer my STEEM or Steem Dollars into savings?</a>
- <a href="/faq.html#How_do_I_send_money_to_another_user">How do I send money to another user?</a>
- <a href="/faq.html#Will_I_receive_notifications_when_there_is_activity_with_my_account">Will I receive notifications when there is activity with my account?</a>
- <a href="/faq.html#What_is_shown_in_my_profile">What is shown in my profile?</a>
- <a href="/faq.html#How_do_I_change_my_avatar_image_and_other_profile_information">How do I change my avatar image and other profile information?</a>
- <a href="/faq.html#What_is_the_recommend_size_for_the_cover_image">What is the recommend size for the cover image?</a>
- <a href="/faq.html#How_can_I_control_whether_I_see__Not_Safe_For_Work___NSFW__content">How can I control whether I see "Not Safe For Work" (NSFW) content?</a>
- <a href="/faq.html#How_do_I_search_for_content">How do I search for content?</a>
- <a href="/faq.html#Can_I_see_which_users_I_have_muted">Can I see which users I have muted?</a>
- <a href="/faq.html#Can_I_see_which_users_have_muted_me">Can I see which users have muted me?</a>
- <a href="/faq.html#Can_I_see_the_list_of_users_I_am_following__and_who_is_following_me">Can I see the list of users I am following, and who is following me?</a>
- <a href="/faq.html#What_languages_are_supported">What languages are supported?</a>

<a class="anchor" name="Table_of_Contents_Posting"></a>
### Posting
- <a href="/faq.html#What_can_users_post_to_Steemit">What can users post to Steemit?</a>
- <a href="/faq.html#What_are_the_different_choices_for_post_rewards__50__50___Power_Up_100___Decline_Payout">What are the different choices for post rewards (50%/50%, Power Up 100%, Decline Payout)?</a>
- <a href="/faq.html#How_do_I_add_images_and_photos_to_my_posts">How do I add images and photos to my posts?</a>
- <a href="/faq.html#How_do_I_set_the_thumbnail_image_for_my_post">How do I set the thumbnail image for my post?</a>
- <a href="/faq.html#What_is_the_recommend_aspect_ratio_for_thumbnail_images">What is the recommend aspect ratio for thumbnail images?</a>
- <a href="/faq.html#How_do_I_add_videos_to_my_posts">How do I add videos to my posts?</a>
- <a href="/faq.html#Is_there_a_way_I_can_make_my_images_smaller">Is there a way I can make my images smaller?</a>
- <a href="/faq.html#What_are_tags">What are tags?</a>
- <a href="/faq.html#What_tags_should_I_use">What tags should I use?</a>
- <a href="/faq.html#How_many_tags_can_I_use">How many tags can I use?</a>
- <a href="/faq.html#Why_is_the_Post_button_grayed_out">Why is the "Post" button grayed out?</a>
- <a href="/faq.html#How_do_I_format_text_in_Markdown">How do I format text in Markdown?</a>
- <a href="/faq.html#How_often_can_I_post">How often can I post?</a>
- <a href="/faq.html#How_long_can_my_post_be">How long can my post be?</a>
- <a href="/faq.html#If_posting_in_a_language_other_than_English__how_will_I_get_recognized">If posting in a language other than English, how will I get recognized?</a>
- <a href="/faq.html#Can_I_delete_something_I_posted">Can I delete something I posted?</a>
- <a href="/faq.html#What_does__Promoting__a_post_do">What does "Promoting" a post do?</a>
- <a href="/faq.html#How_do_I_promote_a_post">How do I promote a post?</a>

<a class="anchor" name="Table_of_Contents_Comments"></a>
### Comments
- <a href="/faq.html#Can_I_earn_digital_tokens_for_commenting">Can I earn digital tokens for commenting?</a>
- <a href="/faq.html#How_often_can_I_comment">How often can I comment?</a>

<a class="anchor" name="Table_of_Contents_Economics"></a>
### Economics
- <a href="/faq.html#Where_do_the_new_STEEM_tokens_come_from">Where do the new STEEM tokens come from?</a>
- <a href="/faq.html#How_many_new_tokens_are_generated_by_the_blockchain">How many new tokens are generated by the blockchain?</a>
- <a href="/faq.html#How_are_the_new_tokens_distributed">How are the new tokens distributed?</a>
- <a href="/faq.html#What_is_the_reward_pool">What is the reward pool?</a>
- <a href="/faq.html#How_is_the_reward_pool_split_between_authors_and_curators">How is the reward pool split between authors and curators?</a>
- <a href="/faq.html#Will_the_reward_pool_pay_out_more_or_less_depending_on_who_votes">Will the reward pool pay out more or less depending on who votes?</a>
- <a href="/faq.html#Why_do_the_earnings_for_my_post_go_up_or_down">Why do the earnings for my post go up or down?</a>
- <a href="/faq.html#When_can_I_claim_my_rewards">When can I claim my rewards?</a>
- <a href="/faq.html#What_is_the_difference_between_STEEM__STEEM_Power__and_Steem_Dollars">What is the difference between STEEM, STEEM Power, and Steem Dollars?</a>
- <a href="/faq.html#What_is_delegated_STEEM_Power">What is delegated STEEM Power?</a>
- <a href="/faq.html#What_determines_the_price_of_STEEM">What determines the price of STEEM?</a>
- <a href="/faq.html#How_do_I_get_more_STEEM_Power">How do I get more STEEM Power?</a>
- <a href="/faq.html#How_long_does_it_take_STEEM_or_STEEM_Power_that_I_purchased_to_show_up_in_my_account">How long does it take STEEM or STEEM Power that I purchased to show up in my account?</a>
- <a href="/faq.html#What_is_powering_up_and_down">What is powering up and down?</a>
- <a href="/faq.html#What_do_the_dollar_amounts_for_pending_payouts_represent">What do the dollar amounts for pending payouts represent?</a>
- <a href="/faq.html#Will_1_Steem_Dollar_always_be_worth__1_00_USD">Will 1 Steem Dollar always be worth $1.00 USD?</a>
- <a href="/faq.html#How_do_Steem_Dollar_to_STEEM_conversions_work">How do Steem Dollar to STEEM conversions work?</a>
- <a href="/faq.html#Is_there_a_way_for_me_to_convert_my_Steem_Dollars_to_STEEM_without_waiting_3_5_days">Is there a way for me to convert my Steem Dollars to STEEM without waiting 3.5 days?</a>
- <a href="/faq.html#What_can_I_do_with_my_STEEM_tokens">What can I do with my STEEM tokens?</a>
- <a href="/faq.html#What_can_I_do_with_my_SBD_tokens">What can I do with my SBD tokens?</a>
- <a href="/faq.html#What_is_a_MVEST">What is a MVEST?</a>
- <a href="/faq.html#Can_I_sell_goods_and_services_on_Steemit">Can I sell goods and services on Steemit?</a>
- <a href="/faq.html#How_can_I_withdraw_my_STEEM_or_SBD_coins">How can I withdraw my STEEM or SBD coins?</a>
- <a href="/faq.html#Will_I_get_a_1099_from_Steemit">Will I get a 1099 from Steemit?</a>
- <a href="/faq.html#How_much_are_the_transaction_fees_for_sending_tokens_to_other_users">How much are the transaction fees for sending tokens to other users?</a>
- <a href="/faq.html#Are_there_fees_for_Powering_Up__Powering_Down__trading_on_the_internal_market__or_converting_SBD_to_STEEM">Are there fees for Powering Up, Powering Down, trading on the internal market, or converting SBD to STEEM?</a>
- <a href="/faq.html#How_long_does_it_take_to_transfer_STEEM_or_SBD_tokens_between_users">How long does it take to transfer STEEM or SBD tokens between users?</a>

<a class="anchor" name="Table_of_Contents_Voting_and_Curating"></a>
### Voting and Curating
- <a href="/faq.html#What_is_my_voting_power">What is my voting power?</a>
- <a href="/faq.html#How_many_times_can_I_vote_without_depleting_my_voting_power">How many times can I vote without depleting my voting power?</a>
- <a href="/faq.html#Can_I_vote_with_less_than_100__of_my_voting_strength">Can I vote with less than 100% of my voting strength?</a>
- <a href="/faq.html#Where_can_I_check_my_voting_power">Where can I check my voting power?</a>
- <a href="/faq.html#What_determines_how_much_of_the_curation_reward_goes_to_the_author_versus_curators">What determines how much of the curation reward goes to the author versus curators?</a>
- <a href="/faq.html#Can_I_get_curation_rewards_for_upvoting_comments">Can I get curation rewards for upvoting comments?</a>
- <a href="/faq.html#Do_I_get_curation_rewards_for_downvoting_posts_or_comments">Do I get curation rewards for downvoting posts or comments?</a>
- <a href="/faq.html#What_are_curation_trails">What are curation trails?</a>
- <a href="/faq.html#Why_don_t_my_upvotes_have_an_effect_on_a_post_s_rewards">Why don't my upvotes have an effect on a post's rewards?</a>
- <a href="/faq.html#Is_there_a_way_to_make_my_votes_count_for_more">Is there a way to make my votes count for more?</a>
- <a href="/faq.html#What_are_the_valid_reasons_for_downvoting">What are the valid reasons for downvoting?</a>
- <a href="/faq.html#Does_a_downvote_mean_that_I_did_something_wrong">Does a downvote mean that I did something wrong?</a>
- <a href="/faq.html#Will_a_downvote_hurt_my_reputation">Will a downvote hurt my reputation?</a>
- <a href="/faq.html#What_is_the_difference_between_a_downvote_and_a_flag">What is the difference between a downvote and a flag?</a>

<a class="anchor" name="Table_of_Contents_Plagiarism__Spam__and_Abuse"></a>
### Plagiarism, Spam, and Abuse
- <a href="/faq.html#What_are_Steemit_s_policies_on_plagiarism_and_spam">What are Steemit’s policies on plagiarism and spam?</a>
- <a href="/faq.html#Is_it_okay_to_use_random_pictures_from_the_internet">Is it okay to use random pictures from the internet?</a>
- <a href="/faq.html#What_is_Steemcleaners">What is Steemcleaners?</a>
- <a href="/faq.html#What_is__cheetah">What is @cheetah?</a>
- <a href="/faq.html#Where_do_I_report_a_post_or_comment_that_contains_plagiarism__spam__or_abuse">Where do I report a post or comment that contains plagiarism, spam, or abuse?</a>

<a class="anchor" name="Table_of_Contents_Reputation"></a>
### Reputation
- <a href="/faq.html#What_is_Reputation">What is Reputation?</a>
- <a href="/faq.html#How_is_the_Reputation_score_measured">How is the Reputation score measured?</a>
- <a href="/faq.html#How_do_I_improve_my_reputation_score">How do I improve my reputation score?</a>
- <a href="/faq.html#What_causes_my_reputation_score_to_go_down">What causes my reputation score to go down?</a>
- <a href="/faq.html#Why_does_my_reputation_score_matter">Why does my reputation score matter?</a>

<a class="anchor" name="Table_of_Contents_Followers__Feeds_and_Resteem"></a>
### Followers, Feeds, and Resteem
- <a href="/faq.html#What_is_Resteeming">What is Resteeming?</a>
- <a href="/faq.html#Can_I_share_on_other_social_media">Can I share on other social media?</a>

<a class="anchor" name="Table_of_Contents_Blockchain"></a>
### Blockchain
- <a href="/faq.html#What_is_a_blockchain">What is a blockchain?</a>
- <a href="/faq.html#What_is_the_Steem_blockchain">What is the Steem blockchain?</a>
- <a href="/faq.html#What_is_the_difference_between_Steem_and_Steemit">What is the difference between Steem and Steemit?</a>
- <a href="/faq.html#How_is_Steem_different_from_Bitcoin">How is Steem different from Bitcoin?</a>
- <a href="/faq.html#What_is_the_difference_between_Proof_of_Work__Proof_of_Stake__and_Delegated_Proof_of_Stake">What is the difference between Proof of Work, Proof of Stake, and Delegated Proof of Stake?</a>
- <a href="/faq.html#How_often_does_the_Steem_blockchain_produce_a_new_block">How often does the Steem blockchain produce a new block?</a>
- <a href="/faq.html#Is_there_a_way_to_see_the_raw_data_that_is_stored_in_the_blockchain">Is there a way to see the raw data that is stored in the blockchain?</a>
- <a href="/faq.html#Where_can_I_find_the_information_for_the_official_launch_of_the_blockchain">Where can I find the information for the official launch of the blockchain?</a>
- <a href="/faq.html#Can_I_mine_STEEM">Can I mine STEEM?</a>

<a class="anchor" name="Table_of_Contents_Steemit__Inc"></a>
### Steemit, Inc.
- <a href="/faq.html#Who_is_the_CEO_of_Steemit">Who is the CEO of Steemit?</a>
- <a href="/faq.html#Can_I_invest_in_Steemit">Can I invest in Steemit?</a>
- <a href="/faq.html#What_does_Steemit_s_development_roadmap_look_like">What does Steemit’s development roadmap look like?</a>
- <a href="/faq.html#Am_I_allowed_to_use_the_Steemit_logo">Am I allowed to use the Steemit logo?</a>
- <a href="/faq.html#Can_I_purchase_official_Steemit_merchandise">Can I purchase official Steemit merchandise?</a>
- <a href="/faq.html#Did_Steemit__pre_mine__tokens">Did Steemit "pre-mine" tokens?</a>
- <a href="/faq.html#What_is_the_Steemit_Privacy_Policy">What is the Steemit Privacy Policy?</a>

<a class="anchor" name="Table_of_Contents_Security"></a>
### Security
- <a href="/faq.html#How_can_I_keep_my_Steem_account_secure">How can I keep my Steem account secure?</a>
- <a href="/faq.html#Why_should_I_be_careful_with_my_master_password">Why should I be careful with my master password?</a>
- <a href="/faq.html#Why_is_the_master_password_a_long_string_of_gibberish">Why is the master password a long string of gibberish?</a>
- <a href="/faq.html#What_are_my_different_keys_for">What are my different keys for?</a>
- <a href="/faq.html#What_do_I_do_if_I_lost_my_password_keys">What do I do if I lost my password/keys?</a>
- <a href="/faq.html#Are_my_STEEM_and_Steem_Dollar_tokens_insured_in_the_event_of_a_hack_or_if_someone_takes_over_my_account">Are my STEEM and Steem Dollar tokens insured in the event of a hack or if someone takes over my account?</a>
- <a href="/faq.html#What_should_I_do_if_I_discover_that_someone_hacked_my_account">What should I do if I discover that someone hacked my account?</a>
- <a href="/faq.html#How_does_the_stolen_account_recovery_process_work">How does the stolen account recovery process work?</a>
- <a href="/faq.html#How_do_I_report_a_security_vulnerability">How do I report a security vulnerability?</a>

<a class="anchor" name="Table_of_Contents_Developers"></a>
### Developers
- <a href="/faq.html#Are_the_Steem_blockchain_and_Steemit_com_code_open_source">Are the Steem blockchain and Steemit.com code open-source?</a>
- <a href="/faq.html#Is_there_a_Github_page_for_Steemit_com">Is there a Github page for Steemit.com?</a>
- <a href="/faq.html#Is_there_a_Github_page_for_the_Steem_blockchain">Is there a Github page for the Steem blockchain?</a>
- <a href="/faq.html#What_is_available_for_developers_interested_in_Steem_and_Steemit">What is available for developers interested in Steem and Steemit?</a>
- <a href="/faq.html#How_do_I_use_cli_wallet">How do I use cli_wallet?</a>

<a class="anchor" name="Table_of_Contents_Witnesses"></a>
### Witnesses
- <a href="/faq.html#What_are_Steem_witnesses">What are Steem witnesses?</a>
- <a href="/faq.html#How_can_I_vote_for_witnesses">How can I vote for witnesses?</a>
- <a href="/faq.html#How_many_witnesses_can_I_vote_for">How many witnesses can I vote for?</a>

<a class="anchor" name="Table_of_Contents_Miscellaneous"></a>
### Miscellaneous
- <a href="/faq.html#What_third_party_tools_are_there_for_Steemit">What third-party tools are there for Steemit?</a>
- <a href="/faq.html#Is_there_an_official_Steemit_Facebook_page">Is there an official Steemit Facebook page?</a>
- <a href="/faq.html#Is_there_an_official_Steemit_Twitter_account">Is there an official Steemit Twitter account?</a>
- <a href="/faq.html#What_is_the_Steem_Whitepaper_and_what_is_its_purpose">What is the Steem Whitepaper and what is its purpose?</a>
- <a href="/faq.html#Where_can_I_ask_for_help_if_my_question_was_not_answered_here">Where can I ask for help if my question was not answered here?</a>

<a class="anchor" name="Table_of_Contents_Disclaimer"></a>
### Disclaimer
- <a href="/faq.html#Third_Party_References_and_User_Links">Third Party References and User Links</a>

# General

<a class="anchor" name="What_is_Steemit_com"></a>
## What is Steemit.com?

Steemit is a social network and content rewards platform that makes the crowd the beneficiaries of the attention economy. It does this be rewarding users with STEEM.

Steemit has redefined social media by building a living, breathing, and growing social economy; a community where users are getting rewarded for sharing their voice.

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="How_does_Steemit_work"></a>
## How does Steemit work?

Steemit is a social media platform that works by having the crowd reward the crowd for their content. It does this thanks to the Steem blockchain and cryptocurrency; Steem is 'minted' daily and distributed to content producers according to the votes they get.

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="How_does_Steemit_differ_from_other_social_media_websites"></a>
## How does Steemit differ from other social media websites?

Most social media sites extract value from their userbase for the benefit of shareholders alone. Steemit is different, it's a new kind of attention economy. By connecting with the Steem blockchain (which is decentralized and controlled by the crowd), Steemit users receive all the benefits and rewards for their attention.

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="Does_it_cost_anything_to_post__comment__or_vote"></a>
## Does it cost anything to post, comment, or vote?

No. It is free to post, comment, and vote on content on Steemit.com. You might even get paid for it!

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="Can_I_earn_digital_tokens_on_Steemit_How"></a>
## Can I earn digital tokens on Steemit? How?

You can earn digital tokens on Steemit by:

**Posting** - By sharing your posts, you can earn upvotes from community members. Depending on the upvotes you receive, you will get a portion of the ongoing Steem reward pool.

**Voting and curating** - If you discover a post and upvote it before it becomes popular, you can earn a curation reward. The reward amount will depend on the amount of STEEM Power you have.

**Purchasing** - Users can purchase STEEM or Steem Dollar tokens directly through the Steemit wallet using bitcoin, Ether, or BitShares tokens. They are also available from other markets and exchanges including BlockTrades, Poloniex, Bittrex, Shapeshift.io, and Changelly. STEEM tokens that are powered up to STEEM Power earn a small amount of interest for holding.

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="Where_do_the_tokens_come_from"></a>
## Where do the tokens come from?

The Steem network continually creates digital tokens to reward content creators and curators. Some of the newly-created tokens are transferred to users who add value to Steemit by posting, commenting, and voting on other people's posts. The remainder is distributed to holders of STEEM Power and the witnesses that power the blockchain.

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="Where_does_the_value_come_from"></a>
## Where does the value come from?

At its root, Steem is simply a points system. However, because this points system is blockchain-based, the points can be traded on markets as tokens. People buy and sell these tokens, and many hold in anticipation of increased purchasing power for various Steem-related services.

By analogy, Steem is a game system where users compete for attention and rewards by bringing content and adding value to the platform. The rewards people earn are tokens that have market value and are readily tradable. It is similar to how someone playing a video game could obtain a limited item or currency by playing the game. If the currency or items are transferable between users, then they can sell or buy them on game item markets.

<a href="/faq.html#Table_of_Contents_General">^</a>
<a class="anchor" name="Why_are_people_getting_vastly_different_rewards"></a>
## Why are people getting vastly different rewards?

Steemit is not a "get rich quick" scheme. While it is possible to post content that goes viral quickly and earn a lot of rewards on a single post, this is not typical for most users.

Most of the authors that you see earning high rewards are users that have spent a lot of time in the network building followings, making connections with others, and developing a reputation for bringing high quality content.

It is best to have realistic expectations, without focusing on rewards when you are first starting out. Work on building a following, making connections, and developing a good reputation. Consistency will pay off in the long run.

<a href="/faq.html#Table_of_Contents_General">^</a>
# Accounts

<a class="anchor" name="How_do_I_create_an_account"></a>
## How do I create an account?

Click on the "Sign Up" link at the top of Steemit.com to get started.

You will be asked to verify your email address and phone number. After your email address and phone number have been verified, you will be added to the waiting list. You will be notified via email once your account is approved.

After you receive notification that your account is approved, click on the link in the email to finish the account creation process. Be sure to save and backup your username and password. It is very important that you do not lose your password. There is no way to recover your password or access your account if it is lost. Once your password is saved and backed up, click on the "Create Account" button to create the account.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="What_information_do_I_need_to_provide_in_order_to_create_an_account"></a>
## What information do I need to provide in order to create an account?

You will need to provide your email address and phone number.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="How_long_does_the_account_approval_process_take"></a>
## How long does the account approval process take?

Most accounts are approved within 24 hours. Some may take up to a week.

If your account has not been approved after one week, please ask for help in the <a href="https://steemit.chat/channel/help">#help</a> channel on <a href="https://steemit.chat/home">steemit.chat</a>.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="Why_do_I_need_to_provide_my_email_and_phone_number"></a>
## Why do I need to provide my email and phone number?

To create an account on the blockchain, it costs STEEM tokens. When you create an account through Steemit.com, Steemit Inc. is supplying the tokens to pay the account creation fee. In order to prevent users from abusing the paid-for signup and creating multiple accounts, we need to be able to verify that each user is only signing up for one account.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="Can_I_create_a_Steem_account_without_an_email_and_phone_number"></a>
## Can I create a Steem account without an email and phone number?

The only way to have an account created via Steemit.com is to supply your email and phone number. Because Steem is an open and permissionless network, there are other ways to create a Steem account. Any Steem blockchain account can be used on Steemit.com

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="What_are_other_ways_to_create_an_account_on_the_blockchain_besides_using_Steemit_com"></a>
## What are other ways to create an account on the blockchain besides using Steemit.com?

If you are willing to pay your own signup fee, then there are other ways to create a new account on the blockchain.

There is a third-party tool called <a href="https://steemit.com/steemit/@someguy123/anonsteem-create-anonymous-steem-accounts-without-social-media">AnonSteem</a> that accepts bitcoin, Litecoin, STEEM, or SBD to anonymously create a Steem account. You do not need to have an existing Steem blockchain account to use the service, but there is a charge on top of the blockchain account creation fee for using the service.

There is also a third-party tool called <a href="https://steemit.com/news/@timcliff/new-tool-from-busy-org-create-new-steem-blockchain-accounts-with-steemconnect">SteemConnect</a> that allows you to create accounts by paying or delegating the account creation fee. There is no additional fee to use the service, but does require an existing Steem blockchain account to pay the account creation fee to create the account.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="It_is_not_letting_me_create_an_account_with_my_phone_number__What_should_I_do"></a>
## It is not letting me create an account with my phone number. What should I do?

Ask for help in the <a href="https://steemit.chat/channel/help">#help</a> channel on <a href="https://steemit.chat/home">steemit.chat</a>.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="What_happens_if_my_email_or_phone_number_changes"></a>
## What happens if my email or phone number changes?

Currently there is no way to change the email or phone number that is linked to your account.  Though once your account is created, you can continue to use it even if the email or phone number that is linked to the account has changed.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="Am_I_allowed_to_create_more_than_one_account"></a>
## Am I allowed to create more than one account?

Each user is allowed only one paid-for account created via Steemit.com, however users are allowed to create multiple accounts on the blockchain. Creating additional accounts on the blockchain requires users to pay their own account creation fee for any additional accounts.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
<a class="anchor" name="Can_I_delete_or_deactivate_my_account"></a>
## Can I delete or deactivate my account?

Accounts can not be deactivated or deleted. The account along with all of its activity is permanently stored in the blockchain.

<a href="/faq.html#Table_of_Contents_Accounts">^</a>
# Community

<a class="anchor" name="Is_there_an_Etiquette_Guide_for_Steemit"></a>
## Is there an Etiquette Guide for Steemit?

There are no official rules for participating on Steemit.com, but one of the users @thecryptofiend has created an <a href="https://steemit.com/steemit/@thecryptofiend/the-complete-steemit-etiquette-guide-revision-2-0">Etiquette Guide</a> for the community. While it is not required to follow the suggestions in the guide, they are standards that many users in the community choose to follow.

<a href="/faq.html#Table_of_Contents_Community">^</a>
<a class="anchor" name="Am_I_required_to_verify_my_identity"></a>
## Am I required to verify my identity?

Verification is a process where users give evidence to show that they are the person that they claim to be.  This is to reduce fraud and people impersonating known figures. If you would like to remain anonymous, that is perfectly fine. However if you claim to be someone specific, the community may expect that you verify you are who you say you are.

There are a number of ways to do this. The most common way to verify your identity is by posting a link to your Steemit profile on a website or social media account which you are already known for having such as Twitter, Facebook, LinkedIn, a blog, or photography site.

Many users also like to post a photo or a video which shows them holding up a sheet of paper with the current date and their Steem account name handwritten on it. This is a great way to add a personal touch to verifying.

<a href="/faq.html#Table_of_Contents_Community">^</a>
# Site Navigation

<a class="anchor" name="How_do_I_upvote_a_post_or_comment"></a>
## How do I upvote a post or comment?

To upvote a post or comment, click on the "upvote" icon at the bottom of the post/comment. <Icon name="chevron-up-circle" />

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="What_do_the_Home__New__Hot__Trending__and_Promoted_links_show"></a>
## What do the Home, New, Hot, Trending, and Promoted links show?

These are various ways to sort Steem posts.

**Home** - The most recent posts of the accounts you follow (your feed).

**New** - Posts are sorted by the time posted, with newest first.

**Hot** - Popular posts at the moment.

**Trending** - Posts with the most amount of votes, stake-weighted, recently.

**Promoted** - Listings that are boosted by Steem Dollar payments get promoted for greater visibility.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="What_information_is_available_in_my_account_menu"></a>
## What information is available in my account menu?

You can get to your account menu by clicking on the avatar icon in the top-right corner of a Steemit.com page. 

**Feed** - Here is where you go to see the most recent posts from the people you follow.

**Blog** - Here is where you go to see all of your posts and resteems. It is also where you go to see your profile page that is viewable by other users.

**Comments** - Here is where you go to see all of the comments and replies you have made.

**Replies** - Here is where you go to see all replies other users have made to your posts and comments.

**Wallet** - Here is where you go to see your wallet balances, make transfers, exchange STEEM or Steem Dollars, and Power Up.

**Change Password** - Here is where you go to change your password.

**Settings** - Here is where you go to update your settings.

**Logout** - If you'd like to logout.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="How_do_I_see_my_recent_rewards"></a>
## How do I see my recent rewards?

The Rewards drop-down menu is available on your profile/blog page. Click it and there are two links:

**Curation rewards** - Shows the rewards earned for upvoting posts and comments.

**Author rewards** - Shows the rewards earned by your own posts and comments.

You can also view the same information for other users by visiting their profile.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="What_information_is_shown_in_my_wallet"></a>
## What information is shown in my wallet?

Your wallet shows how many STEEM and Steem Dollar tokens you have in your account. It shows how much STEEM Power it has, and how much SP is delegated. It also shows how many of your STEEM and Steem Dollar tokens are being held in the savings account, which is a balance that is subject to 3 day withdraw waiting period. The wallet page shows any the progress of any Steem Dollar to STEEM conversions as well as the status of a power down. It also shows an estimated value of all the tokens in your account, based on the recent market prices of STEEM and SBD.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="How_do_I_transfer_my_STEEM_or_Steem_Dollars_into_savings"></a>
## How do I transfer my STEEM or Steem Dollars into savings?

Your savings balance is STEEM and SBD tokens that are subject to 3 day withdraw waiting period. This is an extra security measure in case your account credentials are compromised. To transfer STEEM or SBD tokens into savings, click on the drop-down arrow next to STEEM or STEEM DOLLARS in your wallet, and select "Transfer to Savings".

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="How_do_I_send_money_to_another_user"></a>
## How do I send money to another user?

- From your wallet page, click the STEEM or Steem Dollar balances with the down arrow next to them.
- In the drop-down menu, click 'Transfer'. 
- Type the username of the account you want to send the STEEM or Steem Dollars to. Double and triple check spelling.
- Enter the amount of STEEM or Steem Dollars to send.
- Enter a memo to go along with the transaction (optional).
- Click Submit.
- You will be prompted for your password. You will need to enter your master password or active key.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="Will_I_receive_notifications_when_there_is_activity_with_my_account"></a>
## Will I receive notifications when there is activity with my account?

When there is new activity in your feed, you receive a reply from another user, or there is a new transfer in your wallet, you will receive a notification in your account menu. It will show a little red number showing the number of new notifications.

Steemit also allows you to subscribe to receive additional notifications when users mention you in a comment or post.

Currently, there are no options to receive notifications for votes directly on Steemit.com. But, there is a third-party application https://steemstats.com/, developed by @jesta, which has an option to set up additional notifications on your computer.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="What_is_shown_in_my_profile"></a>
## What is shown in my profile?

At the top of your profile is your display name and reputation score. Below your display name is the number of followers you have, the number of posts and comments you have written, and the number of people you are following. It also shows the month and year when your account was created.

You have the option to change your avatar and display name on the Settings page. There, you can set additional information such as "about" information, your location, and add a link to a website of your choosing. You also have the option to set a cover image for your profile.

You can view your own profile by clicking on the link to your Blog in your account menu.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="How_do_I_change_my_avatar_image_and_other_profile_information"></a>
## How do I change my avatar image and other profile information?

Your profile info, avatar image, and cover image are set in your Settings page. In order to update your avatar picture and cover image, you will need to host the images somewhere. This can be done by uploading it to a Steemit comment or post, or using a third-party image host such as <a href="http://postimage.io/">Postimage</a>.  Once your image is uploaded, copy its URL and paste it into the "Profile Picture URL" box for the avatar, or the "Cover Image URL" box for the cover image. Then click the Update button and enter your password or active key.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="What_is_the_recommend_size_for_the_cover_image"></a>
## What is the recommend size for the cover image?

The cover image will be resized/scaled depending on the device being used. Therefore it is recommend to use an image that will still look good when cropped or resized. A 2048x512 image is the optimal size to work for most devices.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="How_can_I_control_whether_I_see__Not_Safe_For_Work___NSFW__content"></a>
## How can I control whether I see "Not Safe For Work" (NSFW) content?

By default, content that users have tagged as "NSFW" will be hidden, but a link will be shown to reveal the content.

You can update your display preference with the Settings page so that NSFW content is always shown by default, remains hidden until clicked, or is completely hidden with no option to reveal.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="How_do_I_search_for_content"></a>
## How do I search for content?

In the upper right corner of Steemit, there is a magnifying glass search link where you can find posts using a keyword search.

There is also an **Explore** link in the main menu, where you can browse through posts based on tags.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="Can_I_see_which_users_I_have_muted"></a>
## Can I see which users I have muted?

Yes. This can be seen under the Settings page.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="Can_I_see_which_users_have_muted_me"></a>
## Can I see which users have muted me?

No. This information is not presented on Steemit.com.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="Can_I_see_the_list_of_users_I_am_following__and_who_is_following_me"></a>
## Can I see the list of users I am following, and who is following me?

Yes. You can see the list of followers or people you are following by clicking on the links on your profile page.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
<a class="anchor" name="What_languages_are_supported"></a>
## What languages are supported?

English is the most-used language used on the Steemit platform, but communities are forming that speak other languages.

<a href="/faq.html#Table_of_Contents_Site_Navigation">^</a>
# Posting

<a class="anchor" name="What_can_users_post_to_Steemit"></a>
## What can users post to Steemit?

Steem is an open platform meant to host and welcome any legal content. Users can post anything they want, whether it be phrases, quotes, blogs, anecdotes, photos, videos, memes, songs, and more. Be creative!

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="What_are_the_different_choices_for_post_rewards__50__50___Power_Up_100___Decline_Payout"></a>
## What are the different choices for post rewards (50%/50%, Power Up 100%, Decline Payout)?

- **50%/50%** - This rewards in half STEEM Power, and half liquid STEEM / Steem Dollars. The ratio of liquid STEEM to Steem Dollars rewarded is based on network conditions at the time of payout. This is the default payout option.

- **Power Up 100%** - This option rewards the post in 100% STEEM Power.

- **Decline Payout** - Use this option to receive no post rewards. Votes will affect the post's position on the trending ranking but no rewards are paid from Steem's reward pool. Replies made to the post are still eligible for rewards.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_do_I_add_images_and_photos_to_my_posts"></a>
## How do I add images and photos to my posts?

You can browse your hard drive to add an image by clicking on the "selecting them" link from within the editor.

If you have an image copied to your clipboard, you can simply paste (`ctrl + v`) while in the post/comment editor, and your image will be uploaded into your post or comment. Due to the file size of these pasted images, this method is only recommended for simple graphics. Photos (.JPG) should be uploaded from your disk.

Pictures can also be hosted on an external site. Paste the image's web address (URL) into the editor and it will automatically be added.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_do_I_set_the_thumbnail_image_for_my_post"></a>
## How do I set the thumbnail image for my post?

The first image in the post will automatically be set as the thumbnail image.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="What_is_the_recommend_aspect_ratio_for_thumbnail_images"></a>
## What is the recommend aspect ratio for thumbnail images?

The recommend aspect ratio for thumbnail images is 16x9.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_do_I_add_videos_to_my_posts"></a>
## How do I add videos to my posts?

To add a YouTube or Vimeo video to your blog post, simply paste the link to the video into the post. 

You can also read <a href="https://steemit.com/steemitguide/@algimantas/detailed-guide-how-to-add-videos-in-steemit">this guide</a> from @algimantas, which has more detailed instructions:

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="Is_there_a_way_I_can_make_my_images_smaller"></a>
## Is there a way I can make my images smaller?

Yes, but the picture must be resized before it is uploaded into the Steemit.com editor. This can be done in your favorite photo editing software, or online by uploading to a third-party website that features editing such as imgur.com.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="What_are_tags"></a>
## What are tags?

Tags are a way to categorize your content, so that others can find it. The more relevant the tags are to the post, the more like-minded people will come across it.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="What_tags_should_I_use"></a>
## What tags should I use?

Try to use tags that are relevant to your post, and that will be popular for other people to browse. For example, "mytriptoalaska" may be relevant to your post, but readers are probably not going to go searching for that. Using "travel" would be a better choice for a tag in this case.

You can browse through commonly used tags using the "Explore" link, in the main menu.

Be mindful when choosing tags. If your tags aren’t related to your post, your post may get downvotes for mistagging.

All tags must be lowercase letters. Spaces aren't allowed, but hyphenated words with a single dash are.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_many_tags_can_I_use"></a>
## How many tags can I use?

You can use up to 5 tags per post. 

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="Why_is_the_Post_button_grayed_out"></a>
## Why is the "Post" button grayed out?

A post must have a title, body, and at least one valid tag. If any of these are missing, then the "Post" button will be disabled.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_do_I_format_text_in_Markdown"></a>
## How do I format text in Markdown?

Some common markdown syntax is:
- `**bold**` **bold**
- `_italics_` _italics_
- `~~cross out~~` ~~cross out~~

Text can be sized using headers:
```
# H1
## H2
### H3
#### H4
```
# H1
## H2
### H3
#### H4

For more advanced formatting, a guide describing the common markdown formatting syntax can be found here: <a href="https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet">Markdown Cheatsheet</a>

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_often_can_I_post"></a>
## How often can I post?

You are allowed to post almost as often as you like. Currently, posts must be spaced 5 minutes apart. However, the community may not find value in users that are posting too frequently. Keep in mind what your audience will be interested in viewing, so that you do not overwhelm your followers with too much content.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_long_can_my_post_be"></a>
## How long can my post be?

Post sizes are limited to about 64,000 characters including formatting. This is ample for most posts. If writing blogs, consider how much people are willing to read at one time. If you make your posts too long, readers may lose interest which may affect the amount of upvotes and rewards you receive.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="If_posting_in_a_language_other_than_English__how_will_I_get_recognized"></a>
## If posting in a language other than English, how will I get recognized?

You can use language-specific tags to help you to reach the audience that speaks your language. 

Language-specific groups include:
- Chinese = cn
- German = deutsch
- Spanish = spanish
- Korean = kr
- Russian = ru
- French = fr
- Portuguese = pt

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="Can_I_delete_something_I_posted"></a>
## Can I delete something I posted?

The blockchain will always contain the full edit history of posts and comments, so it can never be completely deleted. If you would like to update a post so that users cannot see the content via Steemit.com, you can edit the post and replace it with blank content for as long as the post is active. After seven days, the post can no longer be edited.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="What_does__Promoting__a_post_do"></a>
## What does "Promoting" a post do?

When you make a post, there is the option to promote it with Steem Dollars. It will then show up in the “Promoted” tab. The order that it appears in the list depends on how much the post was promoted for. Posts with a higher promoted amount will be higher than posts with less.

Steem Dollars spent to promote a post are paid to the account @null, which nobody owns or controls. Once a user transfers SBD to @null, the Steem blockchain removes them from the currency supply. Details can be found in this <a href="https://steemit.com/steemit/@steemitblog/introducing-promoted-content">official post</a>.

You can promote your own posts, or posts that you like from other users.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
<a class="anchor" name="How_do_I_promote_a_post"></a>
## How do I promote a post?

At the bottom of each post is a button to "Promote". After clicking the button, type the number of Steem Dollars that you want to spend and click “PROMOTE”. The operation will require your master password or active key.

<a href="/faq.html#Table_of_Contents_Posting">^</a>
# Comments

<a class="anchor" name="Can_I_earn_digital_tokens_for_commenting"></a>
## Can I earn digital tokens for commenting?

Yes, comments that are upvoted can earn rewards just like posts!

<a href="/faq.html#Table_of_Contents_Comments">^</a>
<a class="anchor" name="How_often_can_I_comment"></a>
## How often can I comment?

There is a 20 second wait time in between comments to limit spam.

<a href="/faq.html#Table_of_Contents_Comments">^</a>
# Economics

<a class="anchor" name="Where_do_the_new_STEEM_tokens_come_from"></a>
## Where do the new STEEM tokens come from?

Blockchains like Steem and Bitcoin produce new tokens each time a block is produced. Unlike Bitcoin, where all of the new coins go to the block producers (called miners), the Steem blockchain allocates a majority of the new tokens to a reward fund. The reward fund gives users tokens for participating in the platform.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_many_new_tokens_are_generated_by_the_blockchain"></a>
## How many new tokens are generated by the blockchain?

Starting with the network's 16th hard fork in December 2016, Steem began creating new tokens at a yearly inflation rate of 9.5%. The inflation rate decreases at a rate of 0.01% every 250,000 blocks, or about 0.5% per year. The inflation will continue decreasing at this pace until the overall inflation rate reaches 0.95%. This will take about 20.5 years from the time hard fork 16 went into effect.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_are_the_new_tokens_distributed"></a>
## How are the new tokens distributed?

Out of the new tokens that are generated:
- 75% go to the reward pool, which is split between authors and curators. 
- 15% of the new tokens are awarded to holders of STEEM Power. 
- The remaining 10% pays for the witnesses to power the blockchain.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_is_the_reward_pool"></a>
## What is the reward pool?

Every day, a fixed amount of STEEM tokens are allocated to the network reward fund, commonly called the "reward pool." These get distributed to authors and curators for posting and voting on content.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_is_the_reward_pool_split_between_authors_and_curators"></a>
## How is the reward pool split between authors and curators?

Up to 25% of a post's payout is awarded to curators (the people who upvoted the post) as a reward for discovering the content. The other 75% is awarded to the author. If curators vote for a post within the first 30 minutes of it being created, a portion of their curation reward is added to the author payout. This portion is linear to the age of the post between 0 and 30 minutes. Therefore upvoting at 15 minutes old will donate half of your potential curation reward to the author.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Will_the_reward_pool_pay_out_more_or_less_depending_on_who_votes"></a>
## Will the reward pool pay out more or less depending on who votes?

There is a fixed amount of STEEM coins that gets added to the rewards pool each day. In the short term, the amount of coins that get paid out may be higher or lower depending on the amount of voting activity, but over time it will pay out the full amount of rewards regardless of who votes.

Votes in Steem are stake-weighted. Therefore voters with more STEEM Power have a greater influence over the allocation than voters with less SP, but their votes do not increase the amount of rewards.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Why_do_the_earnings_for_my_post_go_up_or_down"></a>
## Why do the earnings for my post go up or down?

The amount that is shown next to a post is a "**Potential Payout**". This is an estimated value of how much money the post will make based on the votes that have occurred so far. Depending on various factors, this value can go up or down until the payout window closes:

- If a post receives more upvotes, the potential payout of the post can go up.
- If a post receives more downvotes, the potential payout of the post can go down.
- If other posts receive more upvotes, the potential payout of the post can go down.
- If other posts receive more downvotes, the potential payout of the post can go up.
- If upvotes are removed from a post, the potential payout of the post can go down.
- If downvotes are removed from a post, the potential payout of the post can go up.
- If the price of STEEM goes up, the potential payout of all posts can go up.
- If the price of STEEM goes down, the potential payout of all posts can go down.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="When_can_I_claim_my_rewards"></a>
## When can I claim my rewards?

Posts and comments remain active for 7 days. When the period is over, you are able to claim their earned rewards. In your Wallet, click the Claim Rewards button to add the tokens to your account.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_is_the_difference_between_STEEM__STEEM_Power__and_Steem_Dollars"></a>
## What is the difference between STEEM, STEEM Power, and Steem Dollars?

**STEEM** - STEEM is the base liquid currency token in the platform. STEEM can be powered up into STEEM Power, traded for Steem Dollars, and transferred to other accounts. It is a cryptocurrency token, similar to bitcoin.

**STEEM Power** - STEEM Power (abbreviated SP) is a measurement of how much influence a user has in the Steem network. The more STEEM Power a user holds, the more they can influence the value of posts and comments. STEEM Power is less liquid. If a user wishes to “Power Down” SP, they will receive equal distributions of the STEEM weekly, over a 13 week period.

**Steem Dollars** - Steem Dollars (commonly abbreviated SBD) are liquid stable-value currency tokens designed to be pegged to $1 USD. Steem Dollars can be traded with STEEM, and transferred to other accounts for commerce or exchange.  Steem Dollars may also be converted into STEEM in a process that takes 3.5 days. Steem Dollars can be used to buy things in marketplaces, such as PeerHub.com.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_is_delegated_STEEM_Power"></a>
## What is delegated STEEM Power?

Users have the option to delegate STEEM Power to other users. When a user is delegated STEEM Power, their content votes and curation rewards are calculated as if it were their own STEEM Power. Users are not able to power down or cash out delegated STEEM Power, as it still belongs to the original owner.

Most users will have a small amount of STEEM Power delegated to them by the Steemit account after creating an account via Steemit.com.

Delegated STEEM Power shows up in a user's wallet below their actual STEEM Power balance in parentheses.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_determines_the_price_of_STEEM"></a>
## What determines the price of STEEM?

The price of STEEM is based on the supply and demand of the token, determined by buyers and sellers on the exchanges. It is similar to how the price of a commodity like gold is determined.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_do_I_get_more_STEEM_Power"></a>
## How do I get more STEEM Power?

With STEEM tokens in your wallet, click "Power Up" to turn them into STEEM Power. If you have Steem Dollars, you can convert them to STEEM from your wallet, and then power up the STEEM.

If you don’t already have STEEM or Steem Dollars in your wallet, you can purchase them using bitcoin (BTC), ether (ETH), or BitShares (BTS) tokens. You may purchase BTC on various exchanges, such as Coinbase.com or Localbitcoins.com. 

To buy:
- Click "Buy Steem" from the main menu in the top right corner of Steemit.com, or from your wallet.
- Select the currency to deposit, and enter the amount of that currency you wish to use.
- Enter your Steemit account name (without the @) for "Your receive address".
- Click the "Get Deposit Address" button.
- Send the currency to the provided address.

STEEM purchases made via Steemit.com are facilitated by <a href="https://blocktrades.us">BlockTrades</a>.

bitcoin can also be exchanged for STEEM on external markets such as <a href="https://poloniex.com">Poloniex</a>, <a href="https://bittrex.com">Bittrex</a>, <a href="https://shapeshift.io">ShapeShift.io</a>, and <a href="https://changelly.com">Changelly</a>.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_long_does_it_take_STEEM_or_STEEM_Power_that_I_purchased_to_show_up_in_my_account"></a>
## How long does it take STEEM or STEEM Power that I purchased to show up in my account?

Transactions on the Steem blockchain typically only take about three seconds to process, but when you are purchasing the STEEM tokens using bitcoin or some other token, then the transaction must wait for the transaction to be confirmed on the other network. This can often take several hours, and sometimes even days.    

If you paid using bitcoin, the third party website <a href="https://bitcoinfees.21.co/">bitcoinfees.21.co</a> can estimate the approximate wait time of the transaction based on the fees that were paid. The third party website <a href="https://blockchain.info/">blockchain.info</a> will lookup the fees that were paid on a specific blockchain transaction.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_is_powering_up_and_down"></a>
## What is powering up and down?

**Powering up** - If you have STEEM tokens, you can Power Up to STEEM Power to get more voting influence on posts and comments. Having more STEEM Power also increases the amount of curation rewards and interest that you can earn. More SP also grants more influence on approving Steem witnesses.

**Powering down** - If you have STEEM Power, you can power down to turn it into liquid STEEM over a period of time. The system will transfer 1/13 of your STEEM Power to STEEM each week for about three months (13 weeks), starting 1 week from the time it is started. However, you will lose your influence in the network proportionally to how much is powered down, so think about it carefully. Power downs can be stopped at any time.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_do_the_dollar_amounts_for_pending_payouts_represent"></a>
## What do the dollar amounts for pending payouts represent?

The dollar amounts next to posts and comments are estimates of the potential payout that will occur when the payout period ends, based on the current voting activity and price of STEEM. These potential payout amounts may fluctuate up or down until the payout period ends.

Payouts occur as a combination of STEEM Power and Steem Dollars. Sometimes the blockchain may substitute STEEM in place of the Steem Dollars based on market conditions.

The blockchain estimates the dollar value of STEEM and STEEM Power based on the 3.5 day average price of STEEM reported by the witnesses. The blockchain assumes Steem Dollars are worth approximately one USD.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Will_1_Steem_Dollar_always_be_worth__1_00_USD"></a>
## Will 1 Steem Dollar always be worth $1.00 USD?

The market value of a Steem Dollar is dictated by the supply and demand of the token. Therefore it is possible for 1 SBD to be worth more or less than 1 USD depending on market conditions. However, the network's SBD conversion feature serves as a mechanism to hold Steem Dollars within a small margin of the value of USD.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_do_Steem_Dollar_to_STEEM_conversions_work"></a>
## How do Steem Dollar to STEEM conversions work?

If you convert Steem Dollars to STEEM on the Wallet page, the blockchain will process the transaction over a period of 3.5 days. At the end of the 3.5 days, the SBD will be gone and replaced by approximately $1 USD worth of STEEM tokens. The "approximately 1 USD worth of STEEM tokens" is based on the median STEEM price over the 3.5 days, using the price feeds from the Steem witnesses. Depending on price fluctuations during the 3.5 days it is possible to end up with more or less than $1 USD worth of STEEM per SBD at the end of the conversion.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Is_there_a_way_for_me_to_convert_my_Steem_Dollars_to_STEEM_without_waiting_3_5_days"></a>
## Is there a way for me to convert my Steem Dollars to STEEM without waiting 3.5 days?

You can exchange them. Visit the internal Market, found in the main menu. There you can exchange your SBD for STEEM in real-time at whatever the current market price is.

Depending on market conditions, users may get more STEEM for their SBD by trading them for STEEM on the internal market, rather than using the conversion.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_can_I_do_with_my_STEEM_tokens"></a>
## What can I do with my STEEM tokens?

- "Power Up" to STEEM Power
- Exchange for SBD in the internal market
- Withdraw to an exchange, and trade for BTC or other digital tokens
- Purchase items through third-party stores that accept STEEM tokens

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_can_I_do_with_my_SBD_tokens"></a>
## What can I do with my SBD tokens?

- Hold them as a stable-value token
- Convert to STEEM via your wallet (takes 3.5 days)
- Exchange for STEEM in the internal market
- Withdraw to an exchange, and trade for BTC or other digital tokens
- Purchase items through third-party stores that accept SBD tokens

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="What_is_a_MVEST"></a>
## What is a MVEST?

A VEST is a unit of measurement for STEEM Power. A MVEST is one million VESTS. The amount of STEEM Power in one MVEST can be found on <a href="https://steemd.com/">steemd.com</a> as `steem_per_mvests`.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Can_I_sell_goods_and_services_on_Steemit"></a>
## Can I sell goods and services on Steemit?

Other than making a post and making sales manually, there is no interface for selling items directly on Steemit.com. You can list goods on the third-party website <a href="https://www.peerhub.com">PeerHub.com</a>. Through PeerHub, you can accept payment in Steem Dollars or STEEM, and you have the option to advertise your items through Steemit posts.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_can_I_withdraw_my_STEEM_or_SBD_coins"></a>
## How can I withdraw my STEEM or SBD coins?

STEEM and SBD tokens are readily tradable to bitcoin, which is readily tradable to the local currency of your choice. There is a link to "Sell" your STEEM and SBD tokens in your wallet, which uses the <a href="https://blocktrades.us/">BlockTrades</a> interface.

There are several guides that have been posted by users in the community for using various external exchanges to withdraw STEEM and SBD tokens. Please read the <a href="/faq.html#Disclaimer">disclaimer</a> before using any of these guides to withdraw your coins. The users, guides, and exchanges listed in the guides are not endorsed by Steemit, Inc. Use the guides below at your own risk. 

It is recommended that you withdraw a small amount first, to verify it works before withdrawing a larger amount.

#### Sell Steem Dollars via Poloniex
https://steemit.com/steemit/@ash/steemit-how-to-sell-steem-dollars-via-poloniex-newbie-friendly

#### Withdraw Steem Dollars to a Bitcoin address
https://steemit.com/steem-help/@piedpiper/how-to-withdraw-your-steem-dollars-in-less-that-a-minute

#### Convert Steem Dollars to a country’s currency and withdraw to a bank account
https://steemit.com/tutorial/@beanz/how-to-get-my-usdteemit-money-into-my-bank-account

#### Convert STEEM to many other cryptocurrencies via ShapeShift
https://steemit.com/steemit/@shapeshiftio/official-announcement-shapeshift-has-added-steem-to-the-exchange

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Will_I_get_a_1099_from_Steemit"></a>
## Will I get a 1099 from Steemit?

No, you are not being paid by Steemit. The Steem network rewards you. It is your responsibility to determine what, if any, taxes apply to the transactions you make. Further, it is your responsibility to report and remit the correct tax to the appropriate tax authority. By creating an account, you agree that Steemit Inc is not responsible for determining whether taxes apply to your Steem transactions or for collecting, reporting, withholding, or remitting any taxes arising from any Steem transactions.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_much_are_the_transaction_fees_for_sending_tokens_to_other_users"></a>
## How much are the transaction fees for sending tokens to other users?

There are never any fees for transfers within the Steem network. However, if you transfer Steem to an exchange and convert it to another currency, you will incur a small fee from the exchange.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="Are_there_fees_for_Powering_Up__Powering_Down__trading_on_the_internal_market__or_converting_SBD_to_STEEM"></a>
## Are there fees for Powering Up, Powering Down, trading on the internal market, or converting SBD to STEEM?

No. None of these actions incur any fees.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
<a class="anchor" name="How_long_does_it_take_to_transfer_STEEM_or_SBD_tokens_between_users"></a>
## How long does it take to transfer STEEM or SBD tokens between users?

A transfer of tokens between accounts typically takes 3 seconds. This is far faster than most blockchain tokens.

<a href="/faq.html#Table_of_Contents_Economics">^</a>
# Voting and Curating

<a class="anchor" name="What_is_my_voting_power"></a>
## What is my voting power?

Voting power is like an "energy bar" in a computer game that goes down a little bit every time you vote. You start out with 100% voting power. Every time you vote, you will use a small amount of your voting power.

As you use more of your voting power, your votes will carry less influence. A vote with 50% voting power left will be worth 1/2 as much as a vote cast with 100% voting power. Not to worry, the network recharges your voting power by 20% every day.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="How_many_times_can_I_vote_without_depleting_my_voting_power"></a>
## How many times can I vote without depleting my voting power?

Every 100% vote you cast will use 2% of your remaining voting power. Your voting power will recharge by 20% each day. You can vote more than 10 times per day, but each vote will be worth less, and it will take longer to reach full voting power again.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Can_I_vote_with_less_than_100__of_my_voting_strength"></a>
## Can I vote with less than 100% of my voting strength?

New users can only upvote and downvote with 100% voting strength. 

Once you reach about 500 STEEM Power, you will see a vote slider appear when you vote. You can use the slider to adjust the weight of your vote, between 1% and 100% voting strength. Voting with less than 100% voting weight will use up less voting power, but it will also have less of an influence on the post or comment's rewards.

<img src="https://steemitimages.com/DQmV6c21tzSrgXwPHx4tvuc1UiCXBEvzkLBH9QCZHtVN6Ma/image.png">

Upvotes and downvotes use the same amount of voting power.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Where_can_I_check_my_voting_power"></a>
## Where can I check my voting power?

You can view your current voting power using third party tools such as https://steemd.com/@youraccount or https://steemstats.com.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="What_determines_how_much_of_the_curation_reward_goes_to_the_author_versus_curators"></a>
## What determines how much of the curation reward goes to the author versus curators?

The rewards are allocated so that 75% of the payout goes to the author of the post/comment, and 25% goes to the curator. 

Of the 25% that goes to the curator, that portion will be split between the author and the curator if the curator votes within the first 30 minutes. The split of the 25% between the author and curator during the first 30 minutes is calculated linearly based on the time the vote is cast.

- If a post is upvoted the moment of posting, 100% of the curation reward goes to the author.
- At 3 minutes, 90% goes to the author and 10% to the curator.
- At 15 minutes it's a 50/50 split.
- At 27 minutes, 10% goes to the author and 90% to the curator.
- If a post is upvoted 30 min after posting, 100% of the curation reward goes to the curator.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Can_I_get_curation_rewards_for_upvoting_comments"></a>
## Can I get curation rewards for upvoting comments?

Yes. You can earn curation rewards from upvoting both posts and comments!

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Do_I_get_curation_rewards_for_downvoting_posts_or_comments"></a>
## Do I get curation rewards for downvoting posts or comments?

No. Since downvoting reduces the rewards on a post/comment, it does not earn curation rewards.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="What_are_curation_trails"></a>
## What are curation trails?

Some users decide to use third party applications such as <a href="https://streemian.com/">Streemian</a> to automatically cast votes. Users can automatically vote for the same posts and comments that other users does. Typically they will set this up to follow the votes of users who are good at curating. When a user has other users automatically voting for the same content that they do, the people that automatically vote after them are called their "curation trail". 

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Why_don_t_my_upvotes_have_an_effect_on_a_post_s_rewards"></a>
## Why don't my upvotes have an effect on a post's rewards?

A user with more SP is going to have a larger influence on the rewards than users with less SP. One vote from a user with a lot of SP can often have more of an effect than 100 votes from users with a small amount of SP.

Even though your vote may not have an immediate effect, when it gets added in along with all the other votes at the end of the payout period, it can still affect the payout. It may also cause more users to vote on the post too, because they saw that you upvoted it - so your votes can have an indirect effect on the payout this way.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Is_there_a_way_to_make_my_votes_count_for_more"></a>
## Is there a way to make my votes count for more?

Yes. The more STEEM Power you have, the more influence your votes will have.

The platform does not require that anybody purchase SP in order to participate, and there are many users who have earned a lot of STEEM Power without spending any of their own money. You have the option of purchasing more STEEM Power through your Steemit wallet.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="What_are_the_valid_reasons_for_downvoting"></a>
## What are the valid reasons for downvoting?

Users are allowed to downvote for any reason that they want. There are many users in the community who recommend only using the downvote on posts that are abusive. It is up to you if you want to follow this etiquette.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Does_a_downvote_mean_that_I_did_something_wrong"></a>
## Does a downvote mean that I did something wrong?

Just because you received a downvote does not mean that you did something wrong. The downvoting person may have just been voting to reallocate the rewards in a way that they felt was more beneficial to the other active posts in the platform. Often users will leave a comment explaining why they downvoted, but sometimes they might not. If they left a reason, it is up to you to determine if you did anything wrong, and if there is anything you want to change.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="Will_a_downvote_hurt_my_reputation"></a>
## Will a downvote hurt my reputation?

Not necessarily. See: <a href="/faq.html#What_causes_my_reputation_score_to_go_down">What causes my reputation score to go down?</a>

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
<a class="anchor" name="What_is_the_difference_between_a_downvote_and_a_flag"></a>
## What is the difference between a downvote and a flag?

With the current implementation, there is no difference between a downvote and a flag. They are treated the same at the blockchain level.

<a href="/faq.html#Table_of_Contents_Voting_and_Curating">^</a>
# Plagiarism, Spam, and Abuse

<a class="anchor" name="What_are_Steemit_s_policies_on_plagiarism_and_spam"></a>
## What are Steemit’s policies on plagiarism and spam?

If you are posting plagiarized or copied content, you can get in legal trouble for violating copyright laws. Plagiarized posts and spam are seen as abuse and will be downvoted by community members. If you are posting or using someone else’s content, you must ensure that you have the rights to use the content, and properly reference the sources where you got the material from.

<a href="/faq.html#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
<a class="anchor" name="Is_it_okay_to_use_random_pictures_from_the_internet"></a>
## Is it okay to use random pictures from the internet?

If you are using an image that is not your own, make sure you are allowed to use the image, and cite the source of the image.

Using random pictures from the internet without giving credit is discouraged. You may, however, use photos from “free image” websites such as Pexels.com or Pixabay.com. All photos on Pexels and Pixabay are free for personal and commercial use.

Here is a post from @mindover that has links to many websites that have images you can use:
https://steemit.com/steem-help/@mindover/don-t-plagiarize-images-here-are-13-free-and-legal-ways-to-find-high-quality-photos-you-can-use-on-steemit

<a href="/faq.html#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
<a class="anchor" name="What_is_Steemcleaners"></a>
## What is Steemcleaners?

Steemcleaners are a group of Steemians concerned with plagiarism, copy/paste, spam, scams and other forms of abuse on Steemit. 
https://steemit.com/steemcleaners/@steemcleaners/announcing-steemcleaners-the-steemit-abuse-fighting-team

<a href="/faq.html#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
<a class="anchor" name="What_is__cheetah"></a>
## What is @cheetah?

@cheetah is a bot developed by @anyx that scours Steemit for copy/pasted content. Cheetah will not downvote copied content, but it alerts other users to look into it further.

Abusive accounts (serial plagiarists or identity thieves, for example) will go on Cheetah’s blacklist. These users will get downvoted by @cheetah accounts when they post.

More information on the @cheetah bot can be found in this post:
https://steemit.com/steemit/@cheetah/faq-about-cheetah

<a href="/faq.html#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
<a class="anchor" name="Where_do_I_report_a_post_or_comment_that_contains_plagiarism__spam__or_abuse"></a>
## Where do I report a post or comment that contains plagiarism, spam, or abuse?

You can report any abusive content to the <a href="https://steemit.chat/channel/steemitabuse">#steemitabuse</a> channel on <a href="https://steemit.chat/home">steemit.chat</a>.

<a href="/faq.html#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
# Reputation

<a class="anchor" name="What_is_Reputation"></a>
## What is Reputation?

Every user has a reputation score next to their name. The reputation score is one way Steemit measures the amount of value you have brought to the community. It is also a mechanism that is designed to help reduce abuse of the Steemit platform. 

Your reputation goes up when accounts vote on your content. Getting downvoted by someone with a higher reputation can push your reputation down and make your posts less visible.

Users with a lower reputation score are unable to affect your reputation.

<a href="/faq.html#Table_of_Contents_Reputation">^</a>
<a class="anchor" name="How_is_the_Reputation_score_measured"></a>
## How is the Reputation score measured?

Every new user starts off with a reputation score of 25.

The reputation score is based off of a `log10` system, which means that a score of 40 is about 10x better than a score of 30.

More information about the calculation of the reputation score can be found in this post from @digitalnotvir:
https://steemit.com/steemit/@digitalnotvir/how-reputation-scores-are-calculated-the-details-explained-with-simple-math

<a href="/faq.html#Table_of_Contents_Reputation">^</a>
<a class="anchor" name="How_do_I_improve_my_reputation_score"></a>
## How do I improve my reputation score?

Every time another user upvotes one of your posts or comments, it increases your reputation score. Users with a higher reputation than you will have more of a positive effect. The more STEEM Power that the voter has, the larger the effect is as well. The best way to earn upvotes is by adding value to the Steemit community.

<a href="/faq.html#Table_of_Contents_Reputation">^</a>
<a class="anchor" name="What_causes_my_reputation_score_to_go_down"></a>
## What causes my reputation score to go down?

The only way for your reputation score to go down is to be downvoted by another user. Not all downvotes will cause a reputation loss though.

- Downvotes from users with a lower reputation score than you will not hurt your score. 
- If your post or comment that was downvoted still received more upvotes than downvotes (weighted by SP), then the net effect on your reputation score will still be positive.

<a href="/faq.html#Table_of_Contents_Reputation">^</a>
<a class="anchor" name="Why_does_my_reputation_score_matter"></a>
## Why does my reputation score matter?

A reputation score is one way Steemit measures the amount of value you have brought to the community. In real estate, they say there are three variables of the utmost importance: location, location, location. On Steemit, those things are: reputation, reputation, reputation. It’s not to say other variables aren’t important, but reputation will be an enormous factor in your level of success.

Many Steemians glance at users’ reputation scores when deciding which articles to read because they know higher reputation scores means it is much more likely quality content. Furthermore, the higher your rep, the more effect your vote will have on the reputation of others.

It is worth noting that if your reputation score goes below 0, Steemit will hide your posts and comments making it very difficult to gain monetary rewards and followers. This incentivizes online etiquette and respect for your fellow Steemians.

<a href="/faq.html#Table_of_Contents_Reputation">^</a>
# Followers, Feeds, and Resteem

<a class="anchor" name="What_is_Resteeming"></a>
## What is Resteeming?

This is like reblogging or sharing posts on other platforms.  Once you resteem a post it will appear in your feed and in your followers' feeds as if you had posted it yourself.  Use it conservatively and with caution.  It is great to want to share content you like and appreciate with people you follow, but you don't want to overwhelm your followers either.

<a href="/faq.html#Table_of_Contents_Followers__Feeds_and_Resteem">^</a>
<a class="anchor" name="Can_I_share_on_other_social_media"></a>
## Can I share on other social media?

Yes you can use the share button to share on Facebook, Twitter or LinkedIn. You are welcome to post your Steemit links on other websites and social media sites.

<a href="/faq.html#Table_of_Contents_Followers__Feeds_and_Resteem">^</a>
# Blockchain

<a class="anchor" name="What_is_a_blockchain"></a>
## What is a blockchain?

A blockchain is a public ledger of all transactions ever executed. All of the transactions and data are stored in a distributed database. Each time the database is updated, all of updates are done together in a batch called a 'block'. Each time a new block is produced/added, it is appended on to all of the previous blocks - hence the name "blockchain".

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="What_is_the_Steem_blockchain"></a>
## What is the Steem blockchain?

The Steem blockchain is the publicly accessible distributed database, which records all posts and votes, and distributes the rewards across the network. It is where all of the text content and voting data is stored, and it is where all of the reward calculations and payouts are performed.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="What_is_the_difference_between_Steem_and_Steemit"></a>
## What is the difference between Steem and Steemit?

Steem is the name of the blockchain that stores all of the data and transactions, and processes all of the events that take place. STEEM is also a name for the system’s value token (currency).

Steemit is a front end web interface to interact with the blockchain, and view the blockchain data.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="How_is_Steem_different_from_Bitcoin"></a>
## How is Steem different from Bitcoin?

On a technical level, the two networks rely on the same model of a blockchain, but are built upon different technologies and codebase. Steem is based on a new state-of-the-art blockchain technology called Graphene, which uses "witnesses" instead of "miners" to produce blocks. 

The "delegated proof of stake" model of using witnesses instead of miners allows for greater efficiency in block production. With BTC, 100% of the new coins that are created are allocated to block producers (miners). With the Steem blockchain, only 10% of the new coins are paid to block producers (witnesses). The other 90% of new STEEM coins are awarded to content producers, curators, and STEEM Power holders.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="What_is_the_difference_between_Proof_of_Work__Proof_of_Stake__and_Delegated_Proof_of_Stake"></a>
## What is the difference between Proof of Work, Proof of Stake, and Delegated Proof of Stake?

**Proof of work** - Miners solve a complex mathematical problem. The miner that solves the problem first adds the block to the blockchain. The network rewards the miner for doing so.

**Proof of stake** - Requires ownership, or stake, in the cryptocurrency. The more tokens you own, the more block creation power you have. Benefits: eliminates the need for expensive mining rigs, runs on a tiny fraction of the power, and it requires block producers to have a stake in the network.

**Delegated proof of stake** - Block-creating accounts, called witnesses, are collectively approved by Steem stakeholders. Instead of relying on proof of work to find blocks, the Steem network actively schedules these accounts to improve the time between blocks to 3 seconds.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="How_often_does_the_Steem_blockchain_produce_a_new_block"></a>
## How often does the Steem blockchain produce a new block?

The Steem blockchain schedules witnesses to produce a new block every 3 seconds. 21 witness nodes produce 21 blocks in each 63-second round.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="Is_there_a_way_to_see_the_raw_data_that_is_stored_in_the_blockchain"></a>
## Is there a way to see the raw data that is stored in the blockchain?

Yes. The blockchain data can be viewed in different ways with third-party tools such as <a href="https://steemd.com">steemd.com</a> and <a href="https://steemdb.com">steemdb.com</a>.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="Where_can_I_find_the_information_for_the_official_launch_of_the_blockchain"></a>
## Where can I find the information for the official launch of the blockchain?

The original launch of Steem was on March 23, 2016, announced on <a href="https://bitcointalk.org/index.php?topic=1408726.0">Bitcointalk.org</a>. There was a bug found in the original code though, and a majority of the stakeholders agreed that it would be easier to fix via a re-launch than a hardfork. The blockchain was reset and officially re-launched on March 24, 2016, via <a href="https://bitcointalk.org/index.php?topic=1410943.0">Bitcointalk.org</a>.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
<a class="anchor" name="Can_I_mine_STEEM"></a>
## Can I mine STEEM?

No. Proof of work mining has been removed from Steem.

<a href="/faq.html#Table_of_Contents_Blockchain">^</a>
# Steemit, Inc.

<a class="anchor" name="Who_is_the_CEO_of_Steemit"></a>
## Who is the CEO of Steemit?

Ned Scott, @ned
https://www.linkedin.com/in/nedscott

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
<a class="anchor" name="Can_I_invest_in_Steemit"></a>
## Can I invest in Steemit?

Steemit, Inc. is a privately held company and is not available for public investment.

Though not considered an investment, you can purchase STEEM tokens which can go up or down in value. You can power up these tokens into STEEM Power, which grants more influence in the Steem platform.

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
<a class="anchor" name="What_does_Steemit_s_development_roadmap_look_like"></a>
## What does Steemit’s development roadmap look like?

You can view the 2017 Roadmap here:
https://steemit.com/steemit/@steemitblog/steemit-2017-roadmap

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
<a class="anchor" name="Am_I_allowed_to_use_the_Steemit_logo"></a>
## Am I allowed to use the Steemit logo?

Currently, the Steem and Steemit logos are the same and is free to use. In the future, Steemit, Inc. will have its own logo so that it can be distinguished from Steem. The Steemit logo will be proprietary while Steem and its three S-shaped squiggles will remain open for public use.

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
<a class="anchor" name="Can_I_purchase_official_Steemit_merchandise"></a>
## Can I purchase official Steemit merchandise?

Yes. Official Steemit merchandise can be purchased from [The Steemit Shop](https://thesteemitshop.com/).

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
<a class="anchor" name="Did_Steemit__pre_mine__tokens"></a>
## Did Steemit "pre-mine" tokens?

The STEEM tokens mined by Steemit, Inc. were not "pre-mined". All mining took place after the coin was officially and publicly announced on <a href="https://bitcointalk.org/index.php?topic=1410943.0">Bitcointalk.org</a>.

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
<a class="anchor" name="What_is_the_Steemit_Privacy_Policy"></a>
## What is the Steemit Privacy Policy?

https://steemit.com/privacy.html

<a href="/faq.html#Table_of_Contents_Steemit__Inc">^</a>
# Security

<a class="anchor" name="How_can_I_keep_my_Steem_account_secure"></a>
## How can I keep my Steem account secure?

<b>Save your master password and keep it somewhere safe.</b>

Only log into your account using the key with the appropriate permissions for what you are doing:
- Posting key for every day logins
- Active key when necessary for transfers, power ups, etc.
- Master password or owner key when changing the password

Again, <b>save your master password</b> and keep it safe! If logging in with your post key, make sure you don't overwrite or misplace your original master password.

It is not recommended to share your password or keys with any third party site. Steemit Inc. is developing a login application that can be used on third party Steem front ends.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="Why_should_I_be_careful_with_my_master_password"></a>
## Why should I be careful with my master password?

The master password is used to derive all keys for your account, including the owner key.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="Why_is_the_master_password_a_long_string_of_gibberish"></a>
## Why is the master password a long string of gibberish?

The password has to be long and random for maximum account security.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="What_are_my_different_keys_for"></a>
## What are my different keys for?

**Posting key** - The posting key allows accounts to post, comment, edit, vote, resteem, and follow or mute other accounts. Most users should be logging into Steemit every day with the posting key. You are more likely to have your password or key compromised the more you use it so a limited posting key exists to restrict the damage that a compromised account key would cause.

**Active key** - The active key is meant for more sensitive tasks such as transferring funds, power up/down transactions, converting Steem Dollars, voting for witnesses, updating profile details and avatar, and placing a market order. 

**Memo key** - Currently the memo key is not used.

**Owner key** - The owner key is only meant for use when necessary. It is the most powerful key because it can change any key of an account, including the owner key. Ideally it is meant to be stored offline, and only used to recover a compromised account.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="What_do_I_do_if_I_lost_my_password_keys"></a>
## What do I do if I lost my password/keys?

There is no way to recover your account if you lose your password or owner key! Because your account has real value, it is **very important** that you save your master password somewhere safe where you will not lose it.

It is strongly recommended that you store an offline copy of your password somewhere safe in case of a hard drive failure or other calamity. Consider digital offline storage, such as an external disk or flash drive, as well as printed paper. Use a safe deposit box for best redundancy.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="Are_my_STEEM_and_Steem_Dollar_tokens_insured_in_the_event_of_a_hack_or_if_someone_takes_over_my_account"></a>
## Are my STEEM and Steem Dollar tokens insured in the event of a hack or if someone takes over my account?

No, liquid tokens can not be taken back if stolen or sent to the wrong account. If your tokens are in STEEM Power, it is impossible for a hacker to take out more than 1/13 per week. If your tokens are in savings, there is a three-day wait period for them to become transferable.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="What_should_I_do_if_I_discover_that_someone_hacked_my_account"></a>
## What should I do if I discover that someone hacked my account?

If you made your account through Steemit and it is compromised, immediately visit the <a href="https://steemit.com/recover_account_step_1">Stolen Account Recovery</a> page. This link is also available in the main site menu. You will need to provide the email address that you used when you signed up, your account name, and a master password that was used in the last 30 days.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="How_does_the_stolen_account_recovery_process_work"></a>
## How does the stolen account recovery process work?

If your password has been changed without your consent, then the account designated as your recovery account can generate a new owner key for the account. The account recovery must be completed within 30 days of the password being changed, and you must supply a recent owner key that was valid within the last 30 days.

Steemit Inc. owns the default recovery account (@steem) for all users who sign up using Steemit.com. Steemit can identify users by their original email, Facebook, or Reddit logins that were used to signup via Steemit.com.

If you don't have the master password or owner key that was valid the past 30 days, or are unable to prove that you are the original owner of the account, then your account will be unrecoverable.

<a href="/faq.html#Table_of_Contents_Security">^</a>
<a class="anchor" name="How_do_I_report_a_security_vulnerability"></a>
## How do I report a security vulnerability?

If you find a security issue please report the details to security@steemit.com.

<a href="/faq.html#Table_of_Contents_Security">^</a>
# Developers

<a class="anchor" name="Are_the_Steem_blockchain_and_Steemit_com_code_open_source"></a>
## Are the Steem blockchain and Steemit.com code open-source?

Yes. Both the Steem blockchain and Steemit.com are open-source projects.

Developers should however avoid the use of the term "Steemit" in their own products, and instead refer to the Steem Blockchain or Steem Platform. Steemit refers to Steemit.com, which is owned by Steemit, Inc.

<a href="/faq.html#Table_of_Contents_Developers">^</a>
<a class="anchor" name="Is_there_a_Github_page_for_Steemit_com"></a>
## Is there a Github page for Steemit.com?

https://github.com/steemit/condenser

<a href="/faq.html#Table_of_Contents_Developers">^</a>
<a class="anchor" name="Is_there_a_Github_page_for_the_Steem_blockchain"></a>
## Is there a Github page for the Steem blockchain?

https://github.com/steemit/steem

<a href="/faq.html#Table_of_Contents_Developers">^</a>
<a class="anchor" name="What_is_available_for_developers_interested_in_Steem_and_Steemit"></a>
## What is available for developers interested in Steem and Steemit?

Many software engineers are currently leveraging the open-source code to build their applications on Steem. There are more than sixty so far.

This post from the user @fabien has more information about the Steem API:
https://steemit.com/steemjs/@fabien/steem-api-now-released

<a href="/faq.html#Table_of_Contents_Developers">^</a>
<a class="anchor" name="How_do_I_use_cli_wallet"></a>
## How do I use cli_wallet?

Here is a guide from the user @pfunk explaining how to use the cli_wallet:
https://steemit.com/steemhelp/@pfunk/a-learner-s-guide-to-using-steem-s-cliwallet-part-1

<a href="/faq.html#Table_of_Contents_Developers">^</a>
# Witnesses

<a class="anchor" name="What_are_Steem_witnesses"></a>
## What are Steem witnesses?

The Steem blockchain requires a set of people to create blocks and uses a consensus mechanism called delegated proof of stake, or DPOS. The community elects 'witnesses' to act as the network's block producers and governance body. There are 20 full-time witnesses, producing a block every 63-second round. A 21st position is shared by backup witnesses, who are scheduled proportionally to the amount of stake-weighted community approval they have. Witnesses are compensated with STEEM Power for each block they create.

Steemit leverages Steem because the founders of Steemit believe Steem’s decentralized text content storage and governance model makes Steem an excellent platform for supporting the long term success of its social network and digital currency tokens.

<a href="/faq.html#Table_of_Contents_Witnesses">^</a>
<a class="anchor" name="How_can_I_vote_for_witnesses"></a>
## How can I vote for witnesses?

Visit https://steemit.com/~witnesses

<a href="/faq.html#Table_of_Contents_Witnesses">^</a>
<a class="anchor" name="How_many_witnesses_can_I_vote_for"></a>
## How many witnesses can I vote for?

Each account can vote for up to 30 witnesses.

<a href="/faq.html#Table_of_Contents_Witnesses">^</a>
# Miscellaneous

<a class="anchor" name="What_third_party_tools_are_there_for_Steemit"></a>
## What third-party tools are there for Steemit?

http://steemtools.com/

<a href="/faq.html#Table_of_Contents_Miscellaneous">^</a>
<a class="anchor" name="Is_there_an_official_Steemit_Facebook_page"></a>
## Is there an official Steemit Facebook page?

https://www.facebook.com/steemit/

<a href="/faq.html#Table_of_Contents_Miscellaneous">^</a>
<a class="anchor" name="Is_there_an_official_Steemit_Twitter_account"></a>
## Is there an official Steemit Twitter account?

https://twitter.com/steemit

<a href="/faq.html#Table_of_Contents_Miscellaneous">^</a>
<a class="anchor" name="What_is_the_Steem_Whitepaper_and_what_is_its_purpose"></a>
## What is the Steem Whitepaper and what is its purpose?

The Steem Whitepaper was written to describe the mechanics of the token system that makes decentralized content incentives and distribution possible in a way that can improve web technologies across the board. It is also applicable to Steemit, the first website to plug into the Steem blockchain. Users who have read the Steem Whitepaper will better understand how their interactions with Steemit are interactions with Steem, the decentralized network.

It is worth noting that the Whitepaper hasn’t been updated almost since Steem came into existence. Many changes have been made since then, so much of the Whitepaper is now out of date. It is in the process of being rewritten.

https://steem.io/SteemWhitePaper.pdf

<a href="/faq.html#Table_of_Contents_Miscellaneous">^</a>
<a class="anchor" name="Where_can_I_ask_for_help_if_my_question_was_not_answered_here"></a>
## Where can I ask for help if my question was not answered here?

If you post your question in the <a href="https://steemit.chat/channel/help">#help</a> channel on <a href="https://steemit.chat/home">steemit.chat</a>, the users there may be able to help.

You can also create a post on Steemit.com with the tag #help, and someone in the community may be able to answer it.

<a href="/faq.html#Table_of_Contents_Miscellaneous">^</a>
<a class="anchor" name="Disclaimer"></a>
# Disclaimer

<a class="anchor" name="Third_Party_References_and_User_Links"></a>
## Third Party References and User Links

BlockTrades, Poloniex, Bittrex, Changelly, Shapeshift.io, Coinbase, Localbitcoins, SteemDB, PeerHub, Steemit.chat, SteemTools, AnonSteem, SteemConnect, Streemian, SteemStats, Pixabay, Steemcleaners, Pexels, Postimage, Markdown Cheatsheet, @cheetah, Bitcointalk, bitcoinfees, blockchain.info, and steemd are third party applications/services, and are not owned or maintained by Steemit, Inc. Their listing here, as well as any other third party applications or websites that are listed, does not constitute and endorsement or recommendation on behalf of Steemit, Inc.

All links to user posts were created by our users and do not necessarily represent the views of Steemit, Inc. or its management. Their listing here does not constitute and endorsement or recommendation on behalf of Steemit, Inc.

Please use the third party tools and content at your own risk.

<a href="/faq.html#Table_of_Contents_Disclaimer">^</a>
