## Contributing to Condenser

Everyone is welcome to contribute code to condenser. We have a Code of Conduct; we ask that you please follow it in all your interactions with your fellow contributors.

### How to contribute

1. **Reporting Bugs**: If you encounter a bug or unexpected behavior, please file an issue to report it. Please include, if possible: a description of what happened, the URL of the page, the browser you're using, a screenshot of the bug or error message, and any relevant console output.
2. **Enhancement Suggestions**: If you have an enhancement suggestion, file an issue in this repo. Be clear in describing what problem you are trying to solve or the enhancement to existing functionality you’d like to see. Contributors will review your issue and offer feedback or recommend community development.
3. **Development Discussions**: Developers may open issues to discuss proposed changes. This is to inform the community of potential changes, and to get input from the community and other developers on the implementation.
4. **Pull Requests**: We love community contributions. If you've done some work on an issue and want to see it in the Condenser codebase, please submit a Pull Request, reference the issue in the description and start the title with `community -`. We're working very hard to keep our development practices as open as possible, and this helps us a lot. PRs which include tests, format code to existing conventions, and include documentation generally receive top priority.
   If there is feedback on how to improve the code, please act upon it accordingly. All comments in code review must be resolved or addressed. And remember, you are agreeing to license your code and any intellectual property associated with your code under the same terms as the repository you are contributing to.

## Code of Conduct

Again, please note that this Code of Conduct only applies to the development presence.

### Our Pledge

We welcome your membership in the project and community under the rules that we have set below.

In the interest of fostering an open and welcoming environment, we as contributors and maintainers will work to make your participation on the project and community as fulfilling as possible.

### Our Rules

All members of the project and community must:

1. Show empathy toward other project and community members
2. Use welcoming and inclusive language
3. Respect differing viewpoints and experiences
4. Gracefully accept constructive criticism

All members of the project and community must not:

1. Harm the project and community, or advocate harm to the project and community
2. Insult or make derogatory comments about others
3. Interact with others after they have withdrawn permission to do so

### Our Responsibilities

We will use any and all lawful means to enforce these rules. This includes but is not limited to:

1. Rejecting contributions
2. Removing comments, commits, code, wiki edits, and issues
3. Banning abusers

We will clarify standards of acceptable behavior and we will take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Instances of abusive, harassing, or otherwise unacceptable behavior should be reported. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. Further details of specific enforcement policies may be posted separately.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org/), version 1.4, available at [http://contributor-covenant.org/version/1/4](http://contributor-covenant.org/version/1/4/gg)
