# Elliptic curve cryptography functions (ECC)
Private Key, Public Key, Cryptographic Signature, AES, Encryption / Decryption

```js
import {Address, Aes, PrivateKey, PublicKey, Signature} from "ecc"
```

# Configure
Update `./.npmrc` if you need to change something:
```bash
ecc:default_address_prefix = STM
```

# See Also
* [Config](./config/index.js)
* [Address](./src/address.js)
* [Aes](./src/aes.js)
* [PrivateKey](./src/key_private.js)
* [PublicKey](./src/key_public.js)
* [Signature](./src/signature.js)
