<span id="disable_router_nav_history_direction_check"></span>
# Hive.blog FAQ

## <span id="Table_of_Contents">Table of Contents</span>

### <span id="Table_of_Contents_General">General</span>
- <a href="#What_is_Hive_blog">What is Hive.blog?</a>
- <a href="#How_does_Hive_work">How does Hive.blog work?</a>
- <a href="#How_does_Hive_differ_from_other_social_media_websites">How does Hive.blog differ from other social media websites?</a>
- <a href="#What_do_I_need_to_do_in_order_to_secure_my_account">What do I need to do in order to secure my account?</a>
- <a href="#Does_it_cost_anything_to_post__comment__or_vote">Does it cost anything to post, comment, or vote?</a>
- <a href="#Can_I_earn_digital_tokens_on_Hive_How">Can I earn digital tokens on Hive? How?</a>
- <a href="#Where_do_the_tokens_come_from">Where do the tokens come from?</a>
- <a href="#Where_does_the_value_come_from">Where does the value come from?</a>
- <a href="#Why_are_people_getting_vastly_different_rewards">Why are people getting vastly different rewards?</a>

### <span id="Table_of_Contents_Accounts">Accounts</span>
- <a href="#Can_I_change_my_username">Can I change my username?</a>
- <a href="#Can_I_delete_or_deactivate_my_account">Can I delete or deactivate my account?</a>

### <span id="Table_of_Contents_Community">Community</span>
- <a href="#Am_I_required_to_verify_my_identity">Am I required to verify my identity?</a>

### <span id="Table_of_Contents_Site_Navigation">Site Navigation</span>
- <a href="#How_do_I_upvote_a_post_or_comment">How do I upvote a post or comment?</a>
- <a href="#What_do_the_Home__New__Hot__Trending__and_Promoted_links_show">What do the Home, New, Hot, Trending, and Promoted links show?</a>
- <a href="#What_information_is_available_in_my_account_menu">What information is available in my account menu?</a>
- <a href="#How_do_I_see_my_recent_rewards">How do I see my recent rewards?</a>
- <a href="#What_information_is_shown_in_my_wallet">What information is shown in my wallet?</a>
- <a href="#How_do_I_transfer_my_HIVE_or_Hive_Dollars_into_savings">How do I transfer my HIVE or Hive Dollars into savings?</a>
- <a href="#How_do_I_send_money_to_another_user">How do I send money to another user?</a>
- <a href="#Will_I_receive_notifications_when_there_is_activity_with_my_account">Will I receive notifications when there is activity with my account?</a>
- <a href="#What_is_shown_in_my_profile">What is shown in my profile?</a>
- <a href="#How_do_I_change_my_avatar_image_and_other_profile_information">How do I change my avatar image and other profile information?</a>
- <a href="#What_is_the_recommend_size_for_the_cover_image">What is the recommend size for the cover image?</a>
- <a href="#How_can_I_control_whether_I_see__Not_Safe_For_Work___NSFW__content">How can I control whether I see "Not Safe For Work" (NSFW) content?</a>
- <a href="#How_do_I_search_for_content">How do I search for content?</a>
- <a href="#Can_I_see_which_users_I_have_muted">Can I see which users I have muted?</a>
- <a href="#Can_I_see_which_users_have_muted_me">Can I see which users have muted me?</a>
- <a href="#Can_I_see_the_list_of_users_I_am_following__and_who_is_following_me">Can I see the list of users I am following, and who is following me?</a>
- <a href="#What_languages_are_supported">What languages are supported?</a>

### <span id="Table_of_Contents_Posting">Posting</span>
- <a href="#What_can_users_post_to_Hive">What can users post to Hive.blog?</a>
- <a href="#What_are_the_different_choices_for_post_rewards__50__50___Power_Up_100___Decline_Payout">What are the different choices for post rewards (50%/50%, Power Up 100%, Decline Payout)?</a>
- <a href="#How_do_I_add_images_and_photos_to_my_posts">How do I add images and photos to my posts?</a>
- <a href="#How_do_I_set_the_thumbnail_image_for_my_post">How do I set the thumbnail image for my post?</a>
- <a href="#What_is_the_recommend_aspect_ratio_for_thumbnail_images">What is the recommend aspect ratio for thumbnail images?</a>
- <a href="#How_do_I_add_videos_to_my_posts">How do I add videos to my posts?</a>
- <a href="#Is_there_a_way_I_can_make_my_images_smaller">Is there a way I can make my images smaller?</a>
- <a href="#What_are_tags">What are tags?</a>
- <a href="#What_tags_should_I_use">What tags should I use?</a>
- <a href="#How_many_tags_can_I_use">How many tags can I use?</a>
- <a href="#Why_is_the_Post_button_grayed_out">Why is the "Post" button grayed out?</a>
- <a href="#How_do_I_format_text_in_Markdown">How do I format text in Markdown?</a>
- <a href="#How_often_can_I_post">How often can I post?</a>
- <a href="#How_long_can_my_post_be">How long can my post be?</a>
- <a href="#If_posting_in_a_language_other_than_English__how_will_I_get_recognized">If posting in a language other than English, how will I get recognized?</a>
- <a href="#Can_I_delete_something_I_posted">Can I delete something I posted?</a>
- <a href="#What_does__Promoting__a_post_do">What does "Promoting" a post do?</a>
- <a href="#How_do_I_promote_a_post">How do I promote a post?</a>

### <span id="Table_of_Contents_Comments">Comments</span>
- <a href="#Can_I_earn_digital_tokens_for_commenting">Can I earn digital tokens for commenting?</a>
- <a href="#How_often_can_I_comment">How often can I comment?</a>

### <span id="Table_of_Contents_Economics">Economics</span>
- <a href="#Where_do_the_new_HIVE_tokens_come_from">Where do the new HIVE tokens come from?</a>
- <a href="#How_many_new_tokens_are_generated_by_the_blockchain">How many new tokens are generated by the blockchain?</a>
- <a href="#How_are_the_new_tokens_distributed">How are the new tokens distributed?</a>
- <a href="#Which_exchanges_are_HIVE_and_HBD_listed_on">Which exchanges are HIVE and HBD listed on?</a>
- <a href="#What_is_the_reward_pool">What is the reward pool?</a>
- <a href="#How_is_the_reward_pool_split_between_authors_and_curators">How is the reward pool split between authors and curators?</a>
- <a href="#Will_the_reward_pool_pay_out_more_or_less_depending_on_who_votes">Will the reward pool pay out more or less depending on who votes?</a>
- <a href="#Why_do_the_earnings_for_my_post_go_up_or_down">Why do the earnings for my post go up or down?</a>
- <a href="#When_can_I_claim_my_rewards">When can I claim my rewards?</a>
- <a href="#What_is_the_difference_between_HIVE__HIVE_Power__and_Hive_Dollars">What is the difference between HIVE, HIVE Power, and Hive Dollars?</a>
- <a href="#What_is_delegated_HIVE_Power">What is delegated HIVE Power?</a>
- <a href="#What_determines_the_price_of_HIVE">What determines the price of HIVE?</a>
- <a href="#How_do_I_get_more_HIVE_Power">How do I get more HIVE Power?</a>
- <a href="#How_long_does_it_take_HIVE_or_HIVE_Power_that_I_purchased_to_show_up_in_my_account">How long does it take HIVE or HIVE Power that I purchased to show up in my account?</a>
- <a href="#What_is_powering_up_and_down">What is powering up and down?</a>
- <a href="#What_do_the_dollar_amounts_for_pending_payouts_represent">What do the dollar amounts for pending payouts represent?</a>
- <a href="#Will_1_Hive_Dollar_always_be_worth__1_00_USD">Will 1 Hive Dollar always be worth $1.00 USD?</a>
- <a href="#How_do_Hive_Dollar_to_HIVE_conversions_work">How do Hive Dollar to HIVE conversions work?</a>
- <a href="#Is_there_a_way_for_me_to_convert_my_Hive_Dollars_to_HIVE_without_waiting_3_5_days">Is there a way for me to convert my Hive Dollars to HIVE without waiting 3.5 days?</a>
- <a href="#What_can_I_do_with_my_HIVE_tokens">What can I do with my HIVE tokens?</a>
- <a href="#What_can_I_do_with_my_HBD_tokens">What can I do with my HBD tokens?</a>
- <a href="#What_is_a_MVEST">What is a MVEST?</a>
- <a href="#Can_I_sell_goods_and_services_on_Hive">Can I sell goods and services on Hive?</a>
- <a href="#How_can_I_withdraw_my_HIVE_or_HBD_coins">How can I withdraw my HIVE or HBD coins?</a>
- <a href="#Will_I_get_a_1099_from_Hive">Will I get a 1099 from Hive.blog?</a>
- <a href="#How_much_are_the_transaction_fees_for_sending_tokens_to_other_users">How much are the transaction fees for sending tokens to other users?</a>
- <a href="#Are_there_fees_for_Powering_Up__Powering_Down__trading_on_the_internal_market__or_converting_HBD_to_HIVE">Are there fees for Powering Up, Powering Down, trading on the internal market, or converting HBD to HIVE?</a>
- <a href="#How_long_does_it_take_to_transfer_HIVE_or_HBD_tokens_between_users">How long does it take to transfer HIVE or HBD tokens between users?</a>

### <span id="Table_of_Contents_Voting_and_Curating">Voting and Curating</span>
- <a href="#What_is_my_voting_mana">What is my voting mana?</a>
- <a href="#How_many_times_can_I_vote_without_depleting_my_voting_mana">How many times can I vote without depleting my voting mana?</a>
- <a href="#Can_I_vote_with_less_than_100__of_my_voting_strength">Can I vote with less than 100% of my voting strength?</a>
- <a href="#Where_can_I_check_my_voting_mana">Where can I check my voting mana?</a>
- <a href="#What_determines_how_much_of_the_curation_reward_goes_to_the_author_versus_curators">What determines how much of the curation reward goes to the author versus curators?</a>
- <a href="#Can_I_get_curation_rewards_for_upvoting_comments">Can I get curation rewards for upvoting comments?</a>
- <a href="#Do_I_get_curation_rewards_for_downvoting_posts_or_comments">Do I get curation rewards for downvoting posts or comments?</a>
- <a href="#What_are_curation_trails">What are curation trails?</a>
- <a href="#Why_don_t_my_upvotes_have_an_effect_on_a_post_s_rewards">Why don't my upvotes have an effect on a post's rewards?</a>
- <a href="#Is_there_a_way_to_make_my_votes_count_for_more">Is there a way to make my votes count for more?</a>
- <a href="#What_are_the_valid_reasons_for_downvoting">What are the valid reasons for downvoting?</a>
- <a href="#Does_a_downvote_mean_that_I_did_something_wrong">Does a downvote mean that I did something wrong?</a>
- <a href="#Will_a_downvote_hurt_my_reputation">Will a downvote hurt my reputation?</a>

### <span id="Table_of_Contents_Plagiarism__Spam__and_Abuse">Plagiarism, Spam, and Abuse</span>
- <a href="#What_is_considered_spam_or_abuse">What is considered spam or abuse?</a>
- <a href="#What_are_Hive_s_policies_on_plagiarism">What are Hive.blog’s policies on plagiarism?</a>
- <a href="#Is_it_okay_to_use_random_pictures_from_the_internet">Is it okay to use random pictures from the internet?</a>
- <a href="#What_is_Hivewatchers">What is Hivewatchers?</a>
- <a href="#What_is__cheetah">What is @cheetah?</a>
- <a href="#Where_do_I_report_a_post_or_comment_that_contains_plagiarism__spam__or_abuse">Where do I report a post or comment that contains plagiarism, spam, or abuse?</a>

### <span id="Table_of_Contents_Reputation">Reputation</span>
- <a href="#What_is_Reputation">What is Reputation?</a>
- <a href="#How_is_the_Reputation_score_measured">How is the Reputation score measured?</a>
- <a href="#How_do_I_improve_my_reputation_score">How do I improve my reputation score?</a>
- <a href="#What_causes_my_reputation_score_to_go_down">What causes my reputation score to go down?</a>
- <a href="#Why_does_my_reputation_score_matter">Why does my reputation score matter?</a>

### <span id="Table_of_Contents_Followers__Feeds_and_Reblog">Followers, Feeds, and Reblog</span>
- <a href="#What_is_Reblogging">What is Reblogging?</a>
- <a href="#Can_I_share_on_other_social_media">Can I share on other social media?</a>

### <span id="Table_of_Contents_Blockchain">Blockchain</span>
- <a href="#What_is_a_blockchain">What is a blockchain?</a>
- <a href="#What_is_the_Hive_blockchain">What is the Hive blockchain?</a>
- <a href="#How_do_Resource_Credits_work_on_the_Hive_blockchain">How do Resource Credits work on the Hive blockchain?</a>
- <a href="#What_is_the_difference_between_Hive_and_Hive_blog">What is the difference between Hive and Hive.blog?</a>
- <a href="#How_is_Hive_different_from_Bitcoin">How is Hive different from Bitcoin?</a>
- <a href="#What_is_the_difference_between_Proof_of_Work__Proof_of_Stake__and_Delegated_Proof_of_Stake">What is the difference between Proof of Work, Proof of Stake, and Delegated Proof of Stake?</a>
- <a href="#How_often_does_the_Hive_blockchain_produce_a_new_block">How often does the Hive blockchain produce a new block?</a>
- <a href="#Is_there_a_way_to_see_the_raw_data_that_is_stored_in_the_blockchain">Is there a way to see the raw data that is stored in the blockchain?</a>
- <a href="#Where_can_I_find_the_information_for_the_official_launch_of_the_blockchain">Where can I find the information for the official launch of the blockchain?</a>
- <a href="#Can_I_mine_HIVE">Can I mine HIVE?</a>

### <span id="Table_of_Contents_Security">Security</span>
- <a href="#How_can_I_keep_my_Hive_account_secure">How can I keep my Hive account secure?</a>
- <a href="#Why_should_I_be_careful_with_my_master_password">Why should I be careful with my master password?</a>
- <a href="#Why_is_the_master_password_a_long_string_of_gibberish">Why is the master password a long string of gibberish?</a>
- <a href="#What_are_my_different_keys_for">What are my different keys for?</a>
- <a href="#What_do_I_do_if_I_lost_my_password_keys">What do I do if I lost my password/keys?</a>
- <a href="#Are_my_HIVE_and_Hive_Dollar_tokens_insured_in_the_event_of_a_hack_or_if_someone_takes_over_my_account">Are my HIVE and Hive Dollar tokens insured in the event of a hack or if someone takes over my account?</a>
- <a href="#How_do_I_report_a_security_vulnerability">How do I report a security vulnerability?</a>

### <span id="Table_of_Contents_Developers">Developers</span>
- <a href="#Are_the_Hive_blockchain_and_Hive_blog_code_open_source">Are the Hive blockchain and Hive.blog code open-source?</a>
- <a href="#Is_there_a_Github_page_for_Hive_blog">Is there a Github page for Hive.blog?</a>
- <a href="#Is_there_a_Github_page_for_the_Hive_blockchain">Is there a Github page for the Hive blockchain?</a>
- <a href="#What_is_available_for_developers_interested_in_Hive_and_Hive_blog">What is available for developers interested in Hive and Hive.blog?</a>
- <a href="#How_do_I_use_cli_wallet">How do I use cli_wallet?</a>

### <span id="Table_of_Contents_Witnesses">Witnesses</span>
- <a href="#What_are_Hive_witnesses">What are Hive witnesses?</a>
- <a href="#How_can_I_vote_for_witnesses">How can I vote for witnesses?</a>
- <a href="#How_many_witnesses_can_I_vote_for">How many witnesses can I vote for?</a>

### <span id="Table_of_Contents_Miscellaneous">Miscellaneous</span>
- <a href="#Where_can_I_ask_for_help_if_my_question_was_not_answered_here">Where can I ask for help if my question was not answered here?</a>

### <span id="Table_of_Contents_Disclaimer">Disclaimer</span>
- <a href="#Third_Party_References_and_User_Links">Third Party References and User Links</a>

# General

## <span id="What_is_Hive_blog">What is hive.blog?</span>

Hive has redefined social media by building a living, breathing, and growing social economy - a community where users are rewarded for sharing their voice. It's a new kind of attention economy.

<a href="#Table_of_Contents_General">^</a>
## <span id="How_does_Hive_work">How does Hive.blog work?</span>

Hive.blog is one of the many websites that are powered by the Hive blockchain and HIVE cryptocurrency. All of these websites read and write content to the Hive blockchain, which stores the content in an immutable blockchain ledger, and rewards users for their contributions with digital tokens called HIVE.

Every day, the Hive blockchain mints new HIVE tokens and adds them to a community's "rewards pool". These tokens are then awarded to users for their contributions, based on the votes that their content receives. Users who hold more tokens in their account as "Hive Power" will get to decide where a larger portion of the rewards pool is distributed.

<a href="#Table_of_Contents_General">^</a>
## <span id="How_does_Hive_differ_from_other_social_media_websites">How does Hive.blog differ from other social media websites?</span>

While most social media sites extract this value for the benefit of their shareholders, Hive believes that the users of the platform should receive the benefits and rewards for their attention and the contributions they make to the platform.

<a href="#Table_of_Contents_General">^</a>
## <span id="What_do_I_need_to_do_in_order_to_secure_my_account">What do I need to do in order to secure my account?</span>

Unlike most social media websites, **there is no way to recover your account if you lose your password / owner key!** This is why it is extremely important that you save and backup your password somewhere safe. It is strongly recommended that you store an offline copy in case of a hard drive failure or other calamity. Consider digital offline storage, such as an external disk or flash drive, as well as printed paper stored in a fireproof safe. Use a safe deposit box for best redundancy.

If you leak your private key to another user or a third-party website, that user or website will have full access to your account. This means they can steal it, as well as the funds inside of it. It is therefore not recommended to enter your private key information with any other user or third-party website. If you believe your account has been compromised, you should change your password/keys right away.

Each account has multiple keys, which each have different levels of authority: owner, active, posting, and memo. The information on the different types of keys and their purposes, as well as more information on password and key security, can be found in the section on <a href="#Table_of_Contents_Security">Security</a>.

<a href="#Table_of_Contents_General">^</a>
## <span id="Does_it_cost_anything_to_post__comment__or_vote">Does it cost anything to post, comment, or vote?</span>

No. It is free to post, comment, and vote on content on hive.blog. You might even get paid for it!

<a href="#Table_of_Contents_General">^</a>
## <span id="Can_I_earn_digital_tokens_on_Hive_How">Can I earn digital tokens on Hive? How?</span>

You can earn digital tokens on Hive by:

**Posting** - By sharing your posts, you can earn upvotes from community members. Depending on the upvotes you receive, you may get a portion of the "rewards pool".

**Voting and curating** - If you discover a post and upvote it before it becomes popular, you can earn a curation reward. The reward amount will depend on the amount of Hive Power you have.

**Purchasing** - Users can purchase Hive or Hive Dollar tokens directly through their Hive wallet using bitcoin, Ether, or BitShares tokens. They are also available from other markets and exchanges including [BlockTrades](https://blocktrades.us) and [Ionomy](https://ionomy.com).

**Vesting** - HIVE tokens that are powered up to Hive Power will earn a small amount of new tokens for holding.

<a href="#Table_of_Contents_General">^</a>
## <span id="Where_do_the_tokens_come_from">Where do the tokens come from?</span>

The Hive network continually creates new digital tokens to reward content creators and curators. Some of the newly-created tokens are transferred to users who add value to Hive by posting, commenting, and voting on other people's posts. The remainder is distributed to holders of Hive Power and the witnesses that power the blockchain.

<a href="#Table_of_Contents_General">^</a>
## <span id="Where_does_the_value_come_from">Where does the value come from?</span>

At its root, Hive is simply a points system. However, because this points system is blockchain-based, the points can be traded on markets as tokens. People buy and sell these tokens, and many hold in anticipation of increased purchasing power for various Hive-related services.

By analogy, Hive is a game system where users compete for attention and rewards by bringing content and adding value to the platform. The rewards people earn are tokens that have market value and are readily tradable. It is similar to how someone playing a video game could obtain a limited item or currency by playing the game. If the currency or items are transferable between users, then they can sell or buy them on game item markets.

<a href="#Table_of_Contents_General">^</a>
## <span id="Why_are_people_getting_vastly_different_rewards">Why are people getting vastly different rewards?</span>

Hive is not a "get rich quick" scheme. While it is possible to post content that goes viral quickly and earn a lot of rewards on a single post, this is not typical for most users.

Most of the authors that you see earning high rewards are users that have spent a lot of time in the network building followings, making connections with others, and developing a reputation for bringing high quality content.

It is best to have realistic expectations, without focusing on rewards when you are first starting out. Work on building a following, making connections, and developing a good reputation. Consistency will pay off in the long run.

<a href="#Table_of_Contents_General">^</a>

# Accounts

## <span id="Can_I_change_my_username">Can I change my username?</span>

Account names can not be changed. If you would like a new account name, you must pay to create a new account using a third-party account creation service.

<a href="#Table_of_Contents_Accounts">^</a>
## <span id="Can_I_delete_or_deactivate_my_account">Can I delete or deactivate my account?</span>

Accounts can not be deactivated or deleted. The account along with all of its activity is permanently stored in the blockchain.

<a href="#Table_of_Contents_Accounts">^</a>
# Community

## <span id="Am_I_required_to_verify_my_identity">Am I required to verify my identity?</span>

Verification is a process where users give evidence to show that they are the person that they claim to be.  This is to reduce fraud and people impersonating known figures. If you would like to remain anonymous, that is perfectly fine. However if you claim to be someone specific, the community may expect that you verify you are who you say you are.

There are a number of ways to do this. The most common way to verify your identity is by posting a link to your Hive profile on a website or social media account which you are already known for having such as Twitter, Facebook, LinkedIn, a blog, or photography site.

Many users also like to post a photo or a video which shows them holding up a sheet of paper with the current date and their Hive account name handwritten on it. This is a great way to add a personal touch to verifying.

<a href="#Table_of_Contents_Community">^</a>
# Site Navigation

## <span id="How_do_I_upvote_a_post_or_comment">How do I upvote a post or comment?</span>

To upvote a post or comment, click on the "upvote" icon at the bottom of the post/comment. <Icon name="chevron-up-circle" />

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="What_do_the_Home__New__Hot__Trending__and_Promoted_links_show">What do the Home, New, Hot, Trending, and Promoted links show?</span>

These are various ways to sort Hive posts.

**Home** - The most recent posts of the accounts you follow (your feed).

**New** - Posts are sorted by the time posted, with newest first.

**Hot** - Popular posts at the moment.

**Trending** - Posts with the most amount of votes, stake-weighted, recently.

**Promoted** - Listings that are boosted by Hive Dollar payments get promoted for greater visibility.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="What_information_is_available_in_my_account_menu">What information is available in my account menu?</span>

You can get to your account menu by clicking on the avatar icon in the top-right corner of a hive.blog page.

**Feed** - Here is where you go to see the most recent posts from the people you follow.

**Blog** - Here is where you go to see all of your posts and reblogs. It is also where you go to see your profile page that is viewable by other users.

**Comments** - Here is where you go to see all of the comments and replies you have made.

**Replies** - Here is where you go to see all replies other users have made to your posts and comments.

**Toggle Night Mode** - This will toggle the hive.blog website views between "night" and "day" mode themes.

**Wallet** - This will take you to your wallet, where you go to see your wallet balances, make transfers, exchange HIVE or Hive Dollars, manage your account, and Power Up.

**Settings** - Here is where you go to update your settings.

**Logout** - If you'd like to logout.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="How_do_I_see_my_recent_rewards">How do I see my recent rewards?</span>

The Rewards drop-down menu is available in your wallet. Click it and there are two links:

**Curation rewards** - Shows the rewards earned for upvoting posts and comments.

**Author rewards** - Shows the rewards earned by your own posts and comments.

You can also view the same information for other users by visiting their wallet profile.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="What_information_is_shown_in_my_wallet">What information is shown in my wallet?</span>

Your wallet shows how many Hive and Hive Dollar tokens you have in your account. It shows how much Hive Power it has, and how much HP is delegated. It also shows how many of your HIVE and Hive Dollar tokens are being held in the savings account, which is a balance that is subject to 3 day withdraw waiting period. The wallet page shows any the progress of any Hive Dollar to HIVE conversions as well as the status of a power down. It also shows an estimated value of all the tokens in your account, based on the recent market price of HIVE.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="How_do_I_transfer_my_HIVE_or_Hive_Dollars_into_savings">How do I transfer my HIVE or HIVE Dollars into savings?</span>

Your savings balance is HIVE and HBD tokens that are subject to 3 day withdraw waiting period. This is an extra security measure in case your account credentials are compromised. To transfer HIVE or HBD tokens into savings, click on the drop-down arrow next to HIVE or HIVE DOLLARS in your wallet, and select "Transfer to Savings".

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="How_do_I_send_money_to_another_user">How do I send money to another user?</span>

- From your wallet page, click the HIVE or Hive Dollar balances with the down arrow next to them.
- In the drop-down menu, click 'Transfer'.
- Type the username of the account you want to send the HIVE or Hive Dollars to. Double and triple check the spelling.
- Enter the amount of HIVE or Hive Dollars to send.
- Enter a memo to go along with the transaction (optional).
- Click Submit.
- You will be prompted for your password. You will need to enter your master password or active key.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="Will_I_receive_notifications_when_there_is_activity_with_my_account">Will I receive notifications when there is activity with my account?</span>

Notifications are currently not supported, but they are a feature we are planning to add.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="What_is_shown_in_my_profile">What is shown in my profile?</span>

At the top of your profile is your display name and reputation score. Below your display name is the number of followers you have, the number of posts and comments you have written, and the number of people you are following. It also shows the month and year when your account was created.

You have the option to change your avatar and display name on the [wallet.hive.blog](https://wallet.hive.blog) Settings page. There, you can set additional information such as "about" information, your location, and add a link to a website of your choosing. You also have the option to set a cover image for your profile.

You can view your own profile by clicking on the link to your Blog in your account menu.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="How_do_I_change_my_avatar_image_and_other_profile_information">How do I change my avatar image and other profile information?</span>

Your profile info, avatar image, and cover image are set in your [wallet.hive.blog](https://wallet.hive.blog) Settings page. In order to update your avatar picture and cover image, you will need to host the images somewhere. This can be done by uploading it via the wallet GUI, or using a third-party image hosting site such as <a href="http://postimage.io/">Postimage</a>.  Once your image is uploaded, copy its URL and paste it into the "Profile Picture URL" box for the avatar, or the "Cover Image URL" box for the cover image. Then click the Update button and enter your password or active key.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="What_is_the_recommend_size_for_the_cover_image">What is the recommend size for the cover image?</span>

The cover image will be resized/scaled depending on the device being used. Therefore it is recommend to use an image that will still look good when cropped or resized. A 2048x512 image is the optimal size to work for most devices.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="How_can_I_control_whether_I_see__Not_Safe_For_Work___NSFW__content">How can I control whether I see "Not Safe For Work" (NSFW) content?</span>

By default, content that users have tagged as "NSFW" will be hidden, but a link will be shown to reveal the content.

You can update your display preference with the Settings page so that NSFW content is always shown by default, remains hidden until clicked, or is completely hidden with no option to reveal.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="How_do_I_search_for_content">How do I search for content?</span>

In the upper right corner of Hive.blog, there is a magnifying glass search link where you can find posts using a keyword search.

There is also an **Explore** link in the main menu, where you can browse through posts based on tags.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="Can_I_see_which_users_I_have_muted">Can I see which users I have muted?</span>

Yes. This can be seen under the Settings page.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="Can_I_see_which_users_have_muted_me">Can I see which users have muted me?</span>

This information is not presented on hive.blog, but it is visible on the blockchain level.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="Can_I_see_the_list_of_users_I_am_following__and_who_is_following_me">Can I see the list of users I am following, and who is following me?</span>

Yes. You can see the list of followers or people you are following by clicking on the links on your profile page.

<a href="#Table_of_Contents_Site_Navigation">^</a>
## <span id="What_languages_are_supported">What languages are supported?</span>

Currently hive.blog supports English, Spanish, Russian, French, Italian, Korean, Polish, and Chinese. There are also many communities using the platform that speak other languages. If you are interested in joining our translation team to add additional languages or help support the ones we have, please email us at translate@hive.io.

<a href="#Table_of_Contents_Site_Navigation">^</a>
# Posting

## <span id="What_can_users_post_to_Hive">What can users post to Hive.blog?</span>

Hive is an open platform meant to host and welcome any legal content that complies with our [terms of service](/tos.html). Users can post anything they want, whether it be phrases, quotes, blogs, anecdotes, photos, videos, memes, songs, and more. Be creative!

<a href="#Table_of_Contents_Posting">^</a>
## <span id="What_are_the_different_choices_for_post_rewards__50__50___Power_Up_100___Decline_Payout">What are the different choices for post rewards (50%/50%, Power Up 100%, Decline Payout)?</span>

- **50%/50%** - This rewards in half Hive Power, and half liquid HIVE / Hive Dollars. The ratio of liquid HIVE to Hive Dollars rewarded is based on network conditions at the time of payout. This is the default payout option.

- **Power Up 100%** - This option rewards the post in 100% Hive Power.

- **Decline Payout** - Use this option to receive no post rewards. Votes will affect the post's position on the trending ranking but no rewards are paid from Hive's reward pool. Replies made to the post are still eligible for rewards.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_do_I_add_images_and_photos_to_my_posts">How do I add images and photos to my posts?</span>

You can browse your hard drive to add an image by clicking on the "selecting them" link from within the editor.

If you have an image copied to your clipboard, you can simply paste (`ctrl + v`) while in the post/comment editor, and your image will be uploaded into your post or comment. Due to the file size of these pasted images, this method is only recommended for simple graphics. Photos (.JPG) should be uploaded from your disk.

Pictures can also be hosted on an external site. Paste the image's web address (URL) into the editor and it will automatically be added.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_do_I_set_the_thumbnail_image_for_my_post">How do I set the thumbnail image for my post?</span>

The first image in the post will automatically be set as the thumbnail image.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="What_is_the_recommend_aspect_ratio_for_thumbnail_images">What is the recommend aspect ratio for thumbnail images?</span>

The recommend aspect ratio for thumbnail images is 16x9.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_do_I_add_videos_to_my_posts">How do I add videos to my posts?</span>

To add a DTube, YouTube, or Vimeo video to your blog post, simply paste the URL link to the video into the post.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="Is_there_a_way_I_can_make_my_images_smaller">Is there a way I can make my images smaller?</span>

Yes, but the picture must be resized before it is uploaded into the hive.blog editor. This can be done in your favorite photo editing software, or online by uploading to a third-party website that features editing such as imgur.com.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="What_are_tags">What are tags?</span>

Tags are a way to categorize your content, so that others can find it. The more relevant the tags are to the post, the more like-minded people will come across it.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="What_tags_should_I_use">What tags should I use?</span>

Try to use tags that are relevant to your post, and that will be popular for other people to browse. For example, "mytriptoalaska" may be relevant to your post, but readers are probably not going to go searching for that. Using "travel" would be a better choice for a tag in this case.

You can browse through commonly used tags using the "Explore" link, in the main menu.

Be mindful when choosing tags. If your tags aren’t related to your post, your post may get downvotes for mistagging.

All tags must be lowercase letters. Spaces aren't allowed, but hyphenated words with a single dash are.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_many_tags_can_I_use">How many tags can I use?</span>

You can use up to 8 tags per post.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="Why_is_the_Post_button_grayed_out">Why is the "Post" button grayed out?</span>

A post must have a title, body, and at least one valid tag. If any of these are missing, then the "Post" button will be disabled.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_do_I_format_text_in_Markdown">How do I format text in Markdown?</span>

Some common markdown syntax is:
- `**bold**` **bold**
- `_italics_` _italics_
- `~~cross out~~` ~~cross out~~

Text can be sized using headers:
```
# H1
## H2
### H3
#### H4
```
# H1
## H2
### H3
#### H4

For more advanced formatting, a guide describing the common markdown formatting syntax can be found here: <a href="https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet">Markdown Cheatsheet</a>.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_often_can_I_post">How often can I post?</span>

You are allowed to post almost as often as you like. Currently, posts must be spaced 5 minutes apart. However, the community may not find value in users that are posting too frequently. Keep in mind what your audience will be interested in viewing, so that you do not overwhelm your followers with too much content.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_long_can_my_post_be">How long can my post be?</span>

Post sizes are limited to about 64,000 characters including formatting. This is ample for most posts. If writing blogs, consider how much people are willing to read at one time. If you make your posts too long, readers may lose interest which may affect the amount of upvotes and rewards you receive.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="If_posting_in_a_language_other_than_English__how_will_I_get_recognized">If posting in a language other than English, how will I get recognized?</span>

You can use language-specific tags to help you to reach the audience that speaks your language.

Language-specific groups include:
- Chinese = cn
- German = deutsch
- Spanish = spanish
- Korean = kr
- Russian = ru
- French = fr
- Portuguese = pt

<a href="#Table_of_Contents_Posting">^</a>
## <span id="Can_I_delete_something_I_posted">Can I delete something I posted?</span>

The blockchain will always contain the full edit history of posts and comments, so it can never be completely deleted. If you would like to update a post so that users cannot see the content via hive.blog, you can edit the post and replace it with blank content for as long as the post is active. After seven days, the post can no longer be edited via hive.blog.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="What_does__Promoting__a_post_do">What does "Promoting" a post do?</span>

When you make a post, there is the option to promote it with Hive Dollars. It will then show up in the “Promoted” tab. The order that it appears in the list depends on how much the post was promoted for. Posts with a higher promoted amount will be higher than posts with less.

Hive Dollars spent to promote a post are paid to the account @null, which nobody owns or controls. Once a user transfers SBD to @null, the Hive blockchain removes them from the currency supply.

You can promote your own posts, or posts that you like from other users.

<a href="#Table_of_Contents_Posting">^</a>
## <span id="How_do_I_promote_a_post">How do I promote a post?</span>

At the bottom of each post is a button to "Promote". After clicking the button, type the number of Hive Dollars that you want to spend and click “PROMOTE”. The operation will require your master password or active key.

<a href="#Table_of_Contents_Posting">^</a>
# Comments

## <span id="Can_I_earn_digital_tokens_for_commenting">Can I earn digital tokens for commenting?</span>

Yes, comments that are upvoted can earn rewards just like posts!

<a href="#Table_of_Contents_Comments">^</a>
## <span id="How_often_can_I_comment">How often can I comment?</span>

There is a three second wait time in between comments to limit spam.

<a href="#Table_of_Contents_Comments">^</a>
# Economics

## <span id="Where_do_the_new_HIVE_tokens_come_from">Where do the new HIVE tokens come from?</span>

Blockchains like Hive and Bitcoin produce new tokens each time a block is produced. Unlike Bitcoin, where all of the new coins go to the block producers (called miners), the Hive blockchain allocates a majority of the new tokens to a reward fund called the "rewards pool". The rewards pool gives users tokens for participating in the platform based on the value they add.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_many_new_tokens_are_generated_by_the_blockchain">How many new tokens are generated by the blockchain?</span>

Starting with the network's 16th hard fork in December 2016, Hive began creating new tokens at a yearly inflation rate of 9.5%. The inflation rate decreases at a rate of 0.01% every 250,000 blocks, or about 0.5% per year. The inflation will continue decreasing at this pace until the overall inflation rate reaches 0.95%. This will take about 20.5 years from the time hard fork 16 went into effect.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_are_the_new_tokens_distributed">How are the new tokens distributed?</span>

Out of the new tokens that are generated:
- 65% go to the reward pool, which is split between authors and curators.
- 15% of the new tokens are awarded to holders of Hive Power.
- 10% of the new tokens are awarded to the Hive Proposal System.
- The remaining 10% pays for the witnesses to power the blockchain.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Which_exchanges_are_HIVE_and_HBD_listed_on">Which exchanges are HIVE and HBD listed on?</span>

HIVE and HBD are listed on the following exchanges:

| Exchange        | HIVE           | HBD  |
| ------------- |:-------------:| -----:|
| [BitShares](https://wallet.bitshares.org/)      | Y      |   Y |
| [BlockTrades](https://blocktrades.us) | Y      |    Y |
| [Ionomy](https://ionomy.com) | Y | N |

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_is_the_reward_pool">What is the reward pool?</span>

Every day, a fixed amount of HIVE tokens are allocated to the network reward fund, commonly called the "reward pool." These get distributed to authors and curators for posting and voting on content.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_is_the_reward_pool_split_between_authors_and_curators">How is the reward pool split between authors and curators?</span>

Up to 50% of a post's payout is awarded to curators (the people who upvoted the post) as a reward for discovering the content. The other 50% is awarded to the author.

If curators vote for a post within the first 5 minutes of it being created, a portion of their curation reward remains in the rewards pool for other authors/curators. This portion is linear to the age of the post between 0 and 5 minutes. As an example: upvoting at two minutes will donate 60% of your potential curation reward back to the rewards pool.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Will_the_reward_pool_pay_out_more_or_less_depending_on_who_votes">Will the reward pool pay out more or less depending on who votes?</span>

There is a fixed amount of HIVE coins that gets added to the rewards pool each day. In the short term, the amount of coins that get paid out may be higher or lower depending on the amount of voting activity, but over time it will pay out the full amount of rewards regardless of who votes.

Votes in Hive are stake-weighted. Therefore voters with more Hive Power have a greater influence over the allocation than voters with less HP, but their votes do not increase the amount of rewards in the rewards pool.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Why_do_the_earnings_for_my_post_go_up_or_down">Why do the earnings for my post go up or down?</span>

The amount that is shown next to a post is a "**Potential Payout**". This is an estimated value of how much money the post will make based on the votes that have occurred so far. Depending on various factors, this value can go up or down until the payout window closes:

- If a post receives more upvotes, the potential payout of the post can go up.
- If a post receives more downvotes, the potential payout of the post can go down.
- If other posts receive more upvotes, the potential payout of the post can go down.
- If other posts receive more downvotes, the potential payout of the post can go up.
- If upvotes are removed from a post, the potential payout of the post can go down.
- If downvotes are removed from a post, the potential payout of the post can go up.
- If the price of HIVE goes up, the potential payout of all posts can go up.
- If the price of HIVE goes down, the potential payout of all posts can go down.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="When_can_I_claim_my_rewards">When can I claim my rewards?</span>

Posts and comments remain active for 7 days. When the period is over, you are able to claim their earned rewards. In your Wallet, click the Claim Rewards button to add the tokens to your account.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_is_the_difference_between_HIVE__HIVE_Power__and_Hive_Dollars">What is the difference between HIVE, Hive Power, and Hive Dollars?</span>

**HIVE** - HIVE is the base liquid currency token in the platform. HIVE can be powered up into Hive Power, traded for Hive Dollars, or transferred to other accounts. It is a cryptocurrency token, similar to bitcoin.

**Hive Power** - Hive Power (abbreviated HP) is a measurement of how much influence a user has in the Hive network. The more Hive Power a user holds, the more they can influence the value of posts and comments. Hive Power is less liquid. If a user wishes to “Power Down” HP, they will receive equal distributions of the HIVE weekly, over a 13 week period.

**Hive Dollars** - Hive Dollars (commonly abbreviated HBD) are liquid stable-value currency tokens designed to be pegged to $1 USD. Hive Dollars can be traded with HIVE, and transferred to other accounts for commerce or exchange.  Hive Dollars may also be converted into HIVE via a process that takes 3.5 days. 

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_is_delegated_HIVE_Power">What is delegated Hive Power?</span>

Users have the option to delegate Hive Power to other users. When a user is delegated Hive Power - their Resource Credits, content votes, and curation rewards are calculated as if it were their own Hive Power. Users are not able to power down or cash out delegated Hive Power however, as it still belongs to the original owner.

Most users will have a small amount of Hive Power delegated to them by the Hive account after creating an account.

Delegated Hive Power shows up in a user's wallet below their actual Hive Power balance in parentheses.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_determines_the_price_of_HIVE">What determines the price of HIVE?</span>

The price of HIVE is based on the supply and demand of the token, as determined by buyers and sellers on the exchanges. It is similar to how the price of a commodity like gold is determined.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_do_I_get_more_HIVE_Power">How do I get more Hive Power?</span>

With HIVE tokens in your wallet, click "Power Up" to turn them into Hive Power. If you have Hive Dollars, you can convert them to HIVE from your wallet, and then power up the HIVE.

If you don’t already have HIVE or Hive Dollars in your wallet, you can purchase them using bitcoin (BTC), Ether (ETH), Litecoin (LTC), or BitShares (BTS) tokens. You may purchase BTC on various exchanges, such as Coinbase.com or Localbitcoins.com.

To buy:
- Click "Buy Hive" from the main menu in the top right corner of hive.blog, or from your wallet.
- Select the currency to deposit, and enter the amount of that currency you wish to use.
- Enter your Hive account name (without the @) for "Your receive address".
- Click the "Get Deposit Address" button.
- Send the currency to the provided address.

HIVE purchases made via hive.blog are facilitated by <a href="https://blocktrades.us">BlockTrades</a>.

Bitcoin can also be exchanged for HIVE on external markets.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_long_does_it_take_HIVE_or_HIVE_Power_that_I_purchased_to_show_up_in_my_account">How long does it take HIVE or Hive Power that I purchased to show up in my account?</span>

Transactions on the Hive blockchain typically only take about three seconds to process, but when you are purchasing the HIVE tokens using bitcoin or some other token, then the transaction must wait for the transaction to be confirmed on the other network. This can take several hours, and sometimes even days.    

If you paid using bitcoin, the third party website <a href="https://bitcoinfees.21.co/">bitcoinfees.21.co</a> can estimate the approximate wait time of the transaction based on the fees that were paid. The third party website <a href="https://blockchain.info/">blockchain.info</a> will lookup the fees that were paid on a specific blockchain transaction.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_is_powering_up_and_down">What is powering up and down?</span>

**Powering up** - If you have HIVE tokens, you can Power Up to Hive Power to get more voting influence on posts and comments. Having more Hive Power also increases the amount of curation rewards and new vested tokens that you can earn. More HP also grants more influence on approving Hive witnesses.

**Powering down** - If you have Hive Power, you can power down to turn it into liquid HIVE over a period of time. The system will transfer 1/13 of your Hive Power to HIVE each week for about three months (13 weeks), starting 1 week from the time it is started. However, you will lose your influence in the network proportionally to how much is powered down, so think about it carefully. Power downs can be stopped at any time.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_do_the_dollar_amounts_for_pending_payouts_represent">What do the dollar amounts for pending payouts represent?</span>

The dollar amounts next to posts and comments are estimates of the potential payout that will occur when the payout period ends, based on the current voting activity and price of HIVE. These potential payout amounts may fluctuate up or down until the payout period ends.

Payouts occur as a combination of Hive Power and Hive Dollars. Sometimes the blockchain may substitute HIVE in place of the Hive Dollars based on market conditions.

The blockchain estimates the dollar value of HIVE and Hive Power based on the 3.5 day average price of HIVE reported by the witnesses. The blockchain assumes Hive Dollars are worth approximately one USD.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Will_1_Hive_Dollar_always_be_worth__1_00_USD">Will 1 Hive Dollar always be worth $1.00 USD?</span>

The market value of a Hive Dollar is dictated by the supply and demand of the token. Therefore it is possible for 1 HBD to be worth more or less than 1 USD depending on market conditions.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_do_Hive_Dollar_to_HIVE_conversions_work">How do Hive Dollar to HIVE conversions work?</span>

If you convert Hive Dollars to HIVE, the blockchain will process the transaction over a period of 3.5 days. At the end of the 3.5 days, the HBD will be gone and replaced by approximately $1 USD worth of HIVE tokens. The "approximately 1 USD worth of HIVE tokens" is based on the median HIVE price over the 3.5 days, using the price feeds from the Hive witnesses. Depending on price fluctuations during the 3.5 days it is possible to end up with more or less than $1 USD worth of HIVE per HBD at the end of the conversion. This is an advanced user feature, and is currently only available to users using external wallets.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Is_there_a_way_for_me_to_convert_my_Hive_Dollars_to_HIVE_without_waiting_3_5_days">Is there a way for me to convert my Hive Dollars to HIVE without waiting 3.5 days?</span>

You can exchange them. Visit the internal Market, found in the main menu. There you can exchange your HBD for HIVE in real-time at whatever the current market price is.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_can_I_do_with_my_HIVE_tokens">What can I do with my HIVE tokens?</span>

- "Power Up" to Hive Power
- Exchange for HBD in the internal market
- Withdraw to an exchange, and trade for BTC or other digital tokens
- Purchase items through third-party stores that accept HIVE tokens

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_can_I_do_with_my_HBD_tokens">What can I do with my HBD tokens?</span>

- Convert to HIVE via your wallet (takes 3.5 days)
- Exchange for HIVE in the internal market
- Withdraw to an exchange, and trade for BTC or other digital tokens
- Purchase items through third-party stores that accept HBD tokens

<a href="#Table_of_Contents_Economics">^</a>
## <span id="What_is_a_MVEST">What is a MVEST?</span>

A VEST is a unit of measurement for Hive Power. A MVEST is one million VESTS. The amount of Hive Power in one MVEST can be found on <a href="https://hiveblocks.com/">hiveblocks.com</a> as `hive_per_mvests`.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Can_I_sell_goods_and_services_on_Hive">Can I sell goods and services on Hive?</span>

Other than making a post and making sales manually, there is no interface for selling items directly on hive.blog. You can list goods and services on the third-party websites and accept payment in Hive Dollars or HIVE. You also have the option to advertise your items through Hive posts.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_can_I_withdraw_my_HIVE_or_HBD_coins">How can I withdraw my HIVE or HBD coins?</span>

HIVE and HBD tokens are readily tradable to bitcoin, which can be traded for the local currency of your choice. There is a link to "Sell" your HIVE and HBD tokens in your wallet, which uses the <a href="https://blocktrades.us/">BlockTrades</a> interface.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Will_I_get_a_1099_from_Hive">Will I get a 1099 from Hive?</span>

No, you are not being paid by Hive. The Hive network rewards you. It is your responsibility to determine what, if any, taxes apply to the transactions you make. Further, it is your responsibility to report and remit the correct tax to the appropriate tax authority. Hive is not responsible for determining whether taxes apply to your Hive transactions, or for collecting, reporting, withholding, or remitting any taxes arising from any Hive transactions.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_much_are_the_transaction_fees_for_sending_tokens_to_other_users">How much are the transaction fees for sending tokens to other users?</span>

There are never any fees for transfers within the Hive network. However, if you transfer Hive to an exchange and convert it to another currency, you may incur a small fee from the exchange.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="Are_there_fees_for_Powering_Up__Powering_Down__trading_on_the_internal_market__or_converting_HBD_to_HIVE">Are there fees for Powering Up, Powering Down, trading on the internal market, or converting HBD to HIVE?</span>

No. None of these actions incur any fees.

<a href="#Table_of_Contents_Economics">^</a>
## <span id="How_long_does_it_take_to_transfer_HIVE_or_HBD_tokens_between_users">How long does it take to transfer HIVE or HBD tokens between users?</span>

A transfer of tokens between accounts typically takes 3 seconds. This is far faster than most blockchain tokens.

<a href="#Table_of_Contents_Economics">^</a>
# Voting and Curating

## <span id="What_is_my_voting_mana">What is my voting mana?</span>

Voting mana is like an "energy bar" in a computer game that goes down a little bit every time you vote. You start out with 100% voting mana. Every time you vote, you will use a small amount of your voting mana.

As you use more of your voting mana, your votes will carry less influence. A vote with 50% voting mana left will be worth 1/2 as much as a vote cast with 100% voting mana. Not to worry, the network recharges your voting mana by 20% every day.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="How_many_times_can_I_vote_without_depleting_my_voting_mana">How many times can I vote without depleting my voting mana?</span>

Every 100% vote you cast will use 2% of your remaining voting mana. Your voting mana will recharge by 20% each day. You can vote more than 10 times per day, but each vote will be worth less, and it will take longer to reach full voting mana again.

Each user also has a mana pool specifically for down votes. This pool is 25% of the upvote mana pool. Downvotes will consume this mana first before consuming regular mana. When voting, 1/50th of the remaining mana is used for a 100% vote. The same math is used for downvote mana but multiplied by 4 because the downvote mana pool is 25% the size of the normal mana pool. The maximum of these values is used. When both mana pools are at 100%, the values are the same. When downvote mana runs out normal mana is used in the same manner as the current behavior.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Can_I_vote_with_less_than_100__of_my_voting_strength">Can I vote with less than 100% of my voting strength?</span>

New users can only upvote and downvote with 100% voting strength.

Once you reach about 500 Hive Power, you will see a vote slider appear when you vote. You can use the slider to adjust the weight of your vote, between 1% and 100% voting strength. Voting with less than 100% voting weight will use up less voting mana, but it will also have less of an influence on the post or comment's rewards.

<img src="https://images.hive.blog/DQmV6c21tzSrgXwPHx4tvuc1UiCXBEvzkLBH9QCZHtVN6Ma/image.png">

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Where_can_I_check_my_voting_mana">Where can I check my voting mana?</span>

You can view your current voting mana using third party tools such as https://hiveblocks.com/@youraccount.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="What_determines_how_much_of_the_curation_reward_goes_to_the_author_versus_curators">What determines how much of the curation reward goes to the author versus curators?</span>

The rewards are allocated so that 50% of the payout goes to the author of the post/comment, and 50% goes to the curator.

Of the 50% that goes to the curator, the curator will receive less than 100% if the curator votes within the first 5 minutes. The split of the 50% that the curator receives during the first 5 minutes is calculated linearly based on the time the vote is cast.

- If a post is upvoted the moment of posting, 100% of the curation reward will remain in the rewards pool.
- At 1 minute, the curator receives 20%, and 80% remains in the rewards pool.
- At 2 minutes, the curator receives 40%, and 60% remains in the rewards pool.
- At 3 minutes, the curator receives 60%, and 40% remains in the rewards pool.
- At 4 minutes, the curator receives 80%, and 20% remains in the rewards pool.
- If a post is upvoted 5 minutes (or later) after posting, 100% of the curation reward goes to the curator.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Can_I_get_curation_rewards_for_upvoting_comments">Can I get curation rewards for upvoting comments?</span>

Yes. You can earn curation rewards from upvoting both posts and comments!

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Do_I_get_curation_rewards_for_downvoting_posts_or_comments">Do I get curation rewards for downvoting posts or comments?</span>

No. Since downvoting reduces the rewards on a post/comment, it does not earn curation rewards.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="What_are_curation_trails">What are curation trails?</span>

Some users decide to use third party applications to automatically cast votes. Users can automatically vote for the same posts and comments that other users does. Typically they will set this up to follow the votes of users who are good at curating. When a user has other users automatically voting for the same content that they do, the people that automatically vote after them are called their "curation trail".

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Why_don_t_my_upvotes_have_an_effect_on_a_post_s_rewards">Why don't my upvotes have an effect on a post's rewards?</span>

A user with more HP is going to have a larger influence on the rewards than users with less HP. One vote from a user with a lot of HP can often have more of an effect than 100 votes from users with a small amount of HP.

Even though your vote may not have an immediate effect, when it gets added in along with all the other votes at the end of the payout period, it can still affect the payout. It may also cause more users to vote on the post too, because they saw that you upvoted it - so your votes can have an indirect effect on the payout this way.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Is_there_a_way_to_make_my_votes_count_for_more">Is there a way to make my votes count for more?</span>

Yes. The more Hive Power you have, the more influence your votes will have.

The platform does not require that anybody purchase HP in order to participate, and there are many users who have earned a lot of Hive Power without spending any of their own money. You have the option of purchasing more Hive Power through your Hive.blog wallet.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="What_are_the_valid_reasons_for_downvoting">What are the valid reasons for downvoting?</span>

Users are allowed to downvote for any reason that they want. There are many users in the community who recommend only using the downvote on posts that are abusive. It is up to you if you want to follow this etiquette.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Does_a_downvote_mean_that_I_did_something_wrong">Does a downvote mean that I did something wrong?</span>

Just because you received a downvote does not mean that you did something wrong. The downvoting person may have just been voting to reallocate the rewards in a way that they felt was more beneficial to the other active posts in the platform. Often users will leave a comment explaining why they downvoted, but sometimes they might not. If they left a reason, it is up to you to determine if you did anything wrong, and if there is anything you want to change.

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
## <span id="Will_a_downvote_hurt_my_reputation">Will a downvote hurt my reputation?</span>

Not necessarily. See: <a href="#What_causes_my_reputation_score_to_go_down">What causes my reputation score to go down?</a>

<a href="#Table_of_Contents_Voting_and_Curating">^</a>
# Plagiarism, Spam, and Abuse

## <span id="What_is_considered_spam_or_abuse">What is considered spam or abuse?</span>

- Asking for money, views, upvotes, follows, or reblogs.
- Leaving nearly identical or materially similar comments on multiple posts.
- Comments that are unrelated to the topic of discussion.
- Sending unsolicited links or requests to users via wallet memos.
- Posts that require upvotes to enter or play in a contest or game.
- Sending users a link to your blog or a post if it is not relevant to the conversation.
- Posts or comments that include little or nothing more than an offer to trade follows or upvotes.
- Using tags that are unrelated to the post.
- Threatening users with any type of physical violence.
- Not citing sources when using someone else’s material.
- Posting ‘not safe for work’ content without using the “nsfw” tag.
- Selling or offering to buy votes/reblogs/follows, or schemes that facilitate this.
- Scams or Fraudulent offers.

<a href="#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
## <span id="What_are_Hive_s_policies_on_plagiarism">What are Hive.blog's policies on plagiarism?</span>

If you are posting plagiarized or copied content, you can get in legal trouble for violating copyright laws. Plagiarized posts and spam are seen as abuse and will be downvoted by community members. If you are posting or using someone else’s content, you must ensure that you have the rights to use the content, and properly reference the sources where you got the material from.

<a href="#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
## <span id="Is_it_okay_to_use_random_pictures_from_the_internet">Is it okay to use random pictures from the internet?</span>

If you are using an image that is not your own, make sure you are allowed to use the image, and cite the source of the image.

Using random pictures from the internet without giving credit is discouraged. You may, however, use photos from “free image” websites such as Pexels.com or Pixabay.com. All photos on Pexels and Pixabay are free for personal and commercial use.

<a href="#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
## <span id="Where_do_I_report_a_post_or_comment_that_contains_plagiarism__spam__or_abuse">Where do I report a post or comment that contains plagiarism, spam, or abuse?</span>

You can report any abusive content to the <a href="https://openhive.chat/channel/hiveabuse">#hiveabuse</a> channel on <a href="https://openhive.chat/home">openhive.chat</a>.

<a href="#Table_of_Contents_Plagiarism__Spam__and_Abuse">^</a>
# Reputation

## <span id="What_is_Reputation">What is Reputation?</span>

Every user has a reputation score next to their name. The reputation score is one way Hive measures the amount of value you have brought to the community. It is also a mechanism that is designed to help reduce abuse of the Hive platform.

Your reputation goes up when accounts vote on your content. Getting downvoted by someone with a higher reputation can push your reputation down and make your posts less visible.

Users with a lower reputation score are unable to affect your reputation.

<a href="#Table_of_Contents_Reputation">^</a>
## <span id="How_is_the_Reputation_score_measured">How is the Reputation score measured?</span>

Every new user starts off with a reputation score of 25.

The reputation score is based off of a `log10` system, which means that a score of 40 is about 10x better than a score of 30.

More information about the calculation of the reputation score can be found in this post from @digitalnotvir:
https://hive.blog/steemit/@digitalnotvir/how-reputation-scores-are-calculated-the-details-explained-with-simple-math

<a href="#Table_of_Contents_Reputation">^</a>
## <span id="How_do_I_improve_my_reputation_score">How do I improve my reputation score?</span>

Every time another user upvotes one of your posts or comments, it increases your reputation score. The more Hive Power that the voter has, the larger the effect is. The best way to earn upvotes is by adding value to the Hive community.

<a href="#Table_of_Contents_Reputation">^</a>
## <span id="What_causes_my_reputation_score_to_go_down">What causes my reputation score to go down?</span>

The only way for your reputation score to go down is to be downvoted by another user. Not all downvotes will cause a reputation loss though.

- Downvotes from users with a lower reputation score than you will not hurt your score.
- If your post or comment that was downvoted still received more upvotes than downvotes (weighted by HP), then the net effect on your reputation score will still be positive.

<a href="#Table_of_Contents_Reputation">^</a>
## <span id="Why_does_my_reputation_score_matter">Why does my reputation score matter?</span>

A reputation score is one way Hive measures the amount of value you have brought to the community. In real estate, they say there are three variables of the utmost importance: location, location, location. On Hive, those things are: reputation, reputation, reputation. It’s not to say other variables aren’t important, but reputation will be an enormous factor in your level of success.

Many users glance at other users’ reputation scores when deciding which articles to read because they know higher reputation scores means it is much more likely quality content. Furthermore, the higher your rep, the more effect your vote will have on the reputation of others.

It is worth noting that if your reputation score goes below 0, Hive.blog will hide your posts and comments making it very difficult to gain monetary rewards and followers. This incentivizes online etiquette and respect for your fellow users.

<a href="#Table_of_Contents_Reputation">^</a>
# Followers, Feeds, and Rehiving

## <span id="What_is_Rehiving">What is Rehiving?</span>

This is like reblogging or sharing posts on other platforms.  Once you rehive a post it will appear in your feed and in your followers' feeds as if you had posted it yourself.  Use it conservatively and with caution.  It is great to want to share content you like and appreciate with people you follow, but you don't want to overwhelm your followers either.

<a href="#Table_of_Contents_Followers__Feeds_and_Rehive">^</a>
## <span id="Can_I_share_on_other_social_media">Can I share on other social media?</span>

Yes you can use the share button to share on Facebook, Twitter or LinkedIn. You are welcome to post your Hive links on other websites and social media sites.

<a href="#Table_of_Contents_Followers__Feeds_and_Rehive">^</a>
# Blockchain

## <span id="What_is_a_blockchain">What is a blockchain?</span>

A blockchain is a public ledger of all transactions ever executed. All of the transactions and data are stored in a distributed database. Each time the database is updated, all of updates are done together in a batch called a 'block'. Each time a new block is produced/added, it is appended on to all of the previous blocks - hence the name "blockchain".

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="What_is_the_Hive_blockchain">What is the Hive blockchain?</span>

The Hive blockchain is the publicly accessible distributed database, which records all posts and votes, and distributes the rewards across the network. It is where all of the text content and voting data is stored, and it is where all of the reward calculations and payouts are performed.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="How_do_Resource_Credits_work_on_the_Hive_blockchain">How do Resource Credits work on the Hive blockchain?</span>

Since transacting on the Hive blockchain has zero fees, transaction rate-limiting is employed to safeguard the blockchain from spam attacks. Everything action that you take on the blockchain will consume a small amount of Resource Credits. This includes posting, commenting, voting, transferring tokens, etc. Viewing content does not consume Resource Credits.

Every user has a limited amount of Resource Credits to use each week. The more transactions a user does, the less Resource Credits they will have left (until they recharge). Users with more Hive Power will have more Resource Credits.

When the blockchain becomes busy (due to heavy use), the Resource Credit cost of transactions may become higher than during times when the blockchain is less busy.

You can check how many Resource Credits you currently have at:
https://hiveblocks.com/@youraccount

If users do not have enough Resource Credits, they will be unable to transact with the blockchain until their Resource Credits recharge or they acquire additional Hive Power to increase their Resource Credit balance.

If you get an error that you have exceeded your Resource Credit allowance, it is normally best to just wait and try again later. Usually if you wait and try again later, the transaction will go through.

If you are unable to transact for extended periods of time, or you are frequently running into Resource Credit limits, then you will either need to reduce your usage to stay within your limit, or purchase more Hive Power for your account.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="What_is_the_difference_between_Hive_and_Hive_blog">What is the difference between Hive and Hive.blog?</span>

Hive is the name of the blockchain that stores all of the data and transactions, and processes all of the events that take place. HIVE is also a name for the system’s value token (currency).

Hive.blog is a front end web interface to interact with the blockchain, and view the blockchain data.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="How_is_Hive_different_from_Bitcoin">How is Hive different from Bitcoin?</span>

On a technical level, the two networks rely on the same model of a blockchain, but are built upon different technologies and codebase. Hive is based on a new state-of-the-art blockchain technology called Graphene, which uses "witnesses" instead of "miners" to produce blocks.

The "delegated proof of stake" model of using witnesses instead of miners allows for greater efficiency in block production. With BTC, 100% of the new coins that are created are allocated to block producers (miners). With the Hive blockchain, only 10% of the new coins are paid to block producers (witnesses). The other 90% of new HIVE coins are awarded to content producers, curators, and Hive Power holders.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="What_is_the_difference_between_Proof_of_Work__Proof_of_Stake__and_Delegated_Proof_of_Stake">What is the difference between Proof of Work, Proof of Stake, and Delegated Proof of Stake?</span>

**Proof of work** - Miners solve a complex mathematical problem. The miner that solves the problem first adds the block to the blockchain. The network rewards the miner for doing so.

**Proof of stake** - Requires ownership, or stake, in the cryptocurrency. The more tokens you own, the more block creation power you have. Benefits: eliminates the need for expensive mining rigs, runs on a tiny fraction of the power, and it requires block producers to have a stake in the network.

**Delegated proof of stake** - Block-creating accounts, called witnesses, are collectively approved by Hive stakeholders. Instead of relying on proof of work to find blocks, the Hive network actively schedules these accounts to improve the time between blocks to 3 seconds.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="How_often_does_the_Hive_blockchain_produce_a_new_block">How often does the Hive blockchain produce a new block?</span>

The Hive blockchain schedules witnesses to produce a new block every 3 seconds. 21 witness nodes produce 21 blocks in each 63-second round.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="Is_there_a_way_to_see_the_raw_data_that_is_stored_in_the_blockchain">Is there a way to see the raw data that is stored in the blockchain?</span>

Yes. The blockchain data can be viewed in different ways with third-party tools such as <a href="https://hiveblocks.com">hiveblocks.com</a>.

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="Where_can_I_find_the_information_for_the_official_launch_of_the_blockchain">Where can I find the information for the official launch of the blockchain?</span>

See this post by @hiveio - <a href="https://hive.blog/communityfork/@hiveio/announcing-the-launch-of-hive-blockchain">Announcing the Launch of Hive Blockchain</a>

<a href="#Table_of_Contents_Blockchain">^</a>
## <span id="Can_I_mine_HIVE">Can I mine HIVE?</span>

No. Proof of work mining has been removed from Hive.

<a href="#Table_of_Contents_Blockchain">^</a>
# Security

## <span id="How_can_I_keep_my_Hive_account_secure">How can I keep my Hive account secure?</span>

<b>Save your master password and keep it somewhere safe.</b>

Only log into your account using the key with the appropriate permissions for what you are doing:
- Posting key for every day logins
- Active key when necessary for transfers, power ups, etc.
- Master password or owner key when changing the password

Again, <b>save your master password</b> and keep it safe! If logging in with your post key, make sure you don't overwrite or misplace your original master password.

It is not recommended to share your password or keys with any third party site.

<a href="#Table_of_Contents_Security">^</a>
## <span id="Why_should_I_be_careful_with_my_master_password">Why should I be careful with my master password?</span>

The master password is used to derive all keys for your account, including the owner key. If someone has access to your master password, they can steal your account and all of the tokens in it.

<a href="#Table_of_Contents_Security">^</a>
## <span id="Why_is_the_master_password_a_long_string_of_gibberish">Why is the master password a long string of gibberish?</span>

The password has to be long and random for maximum account security.

<a href="#Table_of_Contents_Security">^</a>
## <span id="What_are_my_different_keys_for">What are my different keys for?</span>

**Posting key** - The posting key allows accounts to post, comment, edit, vote, reblog, and follow or mute other accounts. Most users should be logging into Hive every day with the posting key. You are more likely to have your password or key compromised the more you use it so a limited posting key exists to restrict the damage that a compromised account key would cause.

**Active key** - The active key is meant for more sensitive tasks such as transferring funds, power up/down transactions, converting Hive Dollars, voting for witnesses, updating profile details and avatar, and placing a market order.

**Memo key** - Currently the memo key is not used.

**Owner key** - The owner key is only meant for use when necessary. It is the most powerful key because it can change any key of an account, including the owner key. Ideally it is meant to be stored offline, and only used to recover a compromised account.

<a href="#Table_of_Contents_Security">^</a>
## <span id="What_do_I_do_if_I_lost_my_password_keys">What do I do if I lost my password/keys?</span>

There is no way to recover your account if you lose your password or owner key! Because your account has real value, it is **very important** that you save your master password somewhere safe where you will not lose it.

It is strongly recommended that you store an offline copy of your password somewhere safe in case of a hard drive failure or other calamity. Consider digital offline storage, such as an external disk or flash drive, as well as printed paper. Use a safe deposit box for best redundancy.

<a href="#Table_of_Contents_Security">^</a>
## <span id="Are_my_HIVE_and_Hive_Dollar_tokens_insured_in_the_event_of_a_hack_or_if_someone_takes_over_my_account">Are my HIVE and Hive Dollar tokens insured in the event of a hack or if someone takes over my account?</span>

No, liquid tokens can not be taken back if stolen or sent to the wrong account.

If your tokens are in Hive Power, it is impossible for a hacker to take out more than 1/13 per week. If your tokens are in savings, there is a three-day wait period for them to become transferable.

<a href="#Table_of_Contents_Security">^</a>
## <span id="How_do_I_report_a_security_vulnerability">How do I report a security vulnerability?</span>

If you find a security issue please report the details to privacy@hive.io.

<a href="#Table_of_Contents_Security">^</a>
# Developers

## <span id="Are_the_Hive_blockchain_and_Hive_blog_code_open_source">Are the Hive blockchain and hive.blog code open-source?</span>

Yes. Both the Hive blockchain and hive.blog are open-source projects.

Developers should however avoid the use of the term "Hive.blog" in their own products, and instead refer to the Hive Blockchain or Hive Platform.

<a href="#Table_of_Contents_Developers">^</a>
## <span id="Is_there_a_Github_page_for_Hive_blog">Is there a Github page for hive.blog?</span>

Yes. Will be made public after launch

<a href="#Table_of_Contents_Developers">^</a>
## <span id="Is_there_a_Github_page_for_the_Hive_blockchain">Is there a Github page for the Hive blockchain?</span>

Yes. Will be made public after launch

<a href="#Table_of_Contents_Developers">^</a>
## <span id="What_is_available_for_developers_interested_in_Hive_and_Hive_blog">What is available for developers interested in Hive and Hive.blog?</span>

Many software engineers are currently leveraging the open-source code to build their applications on Hive

The [Hive Developer Portal](https://developers.hive.io/) also contains documents and resources for developing tools and applications for the Hive blockchain.

<a href="#Table_of_Contents_Developers">^</a>
## <span id="How_do_I_use_cli_wallet">How do I use cli_wallet?</span>

Here is a guide from the user @pfunk explaining how to use the cli_wallet:
https://hive.blog/steemhelp/@pfunk/a-learner-s-guide-to-using-steem-s-cliwallet-part-1

<a href="#Table_of_Contents_Developers">^</a>
# Witnesses

## <span id="What_are_Hive_witnesses">What are Hive witnesses?</span>

The Hive blockchain requires a set of people to create blocks and uses a consensus mechanism called delegated proof of stake, or DPOS. The community elects 'witnesses' to act as the network's block producers and governance body. There are 20 full-time witnesses, producing a block every 63-second round. A 21st position is shared by the backup witnesses, who are scheduled proportionally to the amount of stake-weighted community approval they have. Witnesses are compensated with Hive Power for each block they create.

<a href="#Table_of_Contents_Witnesses">^</a>
## <span id="How_can_I_vote_for_witnesses">How can I vote for witnesses?</span>

Visit https://wallet.hive.blog/~witnesses.

<a href="#Table_of_Contents_Witnesses">^</a>
## <span id="How_many_witnesses_can_I_vote_for">How many witnesses can I vote for?</span>

Each account can vote for up to 30 witnesses.

<a href="#Table_of_Contents_Witnesses">^</a>
# Miscellaneous

## <span id="Where_can_I_ask_for_help_if_my_question_was_not_answered_here">Where can I ask for help if my question was not answered here?</span>

If you post your question in the <a href="https://openhive.chat/channel/help">#help</a> channel on <a href="https://openhive.chat/home">openhive.chat</a>, the users there may be able to help.
Alternatively, there is a <a href="https://discord.gg/ZcG7jgX">Hive Discord</a> channel that may be able to answer your questions.

You can also create a post on hive.blog with the tag #help, and someone in the community may be able to answer it.

<a href="#Table_of_Contents_Miscellaneous">^</a>

# <span id="Disclaimer">Disclaimer</span>

## <span id="Third_Party_References_and_User_Links">Third Party References and User Links</span>

Any services listed here, as well as any other third party applications or websites that are listed, does not constitute and endorsement or recommendation on behalf of the operators of Hive.blog

Please use the third party tools and content at your own risk.

<a href="#Table_of_Contents_Disclaimer">^</a>
