
# Contributing to Condenser

Everyone is welcome to contribute code to Steemit, Inc. projects. We have a Code of Conduct;
we ask that you please follow it in all your interactions with our team and your fellow
contributors.

Please note that this contributing guide only applies to our development presence.

## How to contribute

1. File an issue describing the problem you would like to
   solve or the feature you would like to add. It saves unnecessary work on your part, 
   in case there's a nontechnical reason we can't accept a particular change.
   Please note that we can and will _automatically close all pull requests that do not refer to
   an issue_.
2. Learn the conventions of the project you are submitting code to, even implicit ones,
   and follow them. In case you have a question about a project's conventions, please
   ask on the issue you filed. This includes writing tests, formatting code, and documentation.
3. File a pull request against your Github issue and fill out the pull request template.
   Remember, you are agreeing to license your code and any intellectual property associated
   with your code under the same terms as the repository you are contributing to.
4. If one of our teammates asks you to make changes, please make them. Our rule is that all
   requests for changes in code review are resolved in favor of the reviewer. Our teammates
   follow this rule too!   
5. **Reporting Bugs** If there is an existing feature that is not working correctly, or a 
    glitch in the website that is impacting user behaviour - please open an issue to report 
    variance. Include as much relevant information as you can, including screen shots and 
    steps to reproduce the issue.
6. **Enhancement Suggestions** If you have an enhancement you would like to see in condenser 
    we suggest you first discuss it with other members of the community on Steemit.com, or 
    in the steemit discord channel. If there is a well vetted idea that has the support of 
    the community create an issue with a link to the discussion. The issue's title should
    start with `community -` and have a detailed description.
7. **Development Discussions** The developers frequently open issues to discuss changes that 
    are being worked on. This is to inform the community of the changes being worked on, and 
    to get input from the community and other developers on the implementation.    
8. **Pull Requests** We love community contributions. If you've done some work on an issue
     and want to see it in the condenser codebase, please submit a Pull Request, reference
     the issue in the description start the title with `community -`. We're working very
     hard to keep our development practices as open as possible, and this helps us a lot. 

## Code of Conduct

Again, please note that this Code of Conduct _only applies to our development presence_.

### Our Pledge

We welcome your membership in our project and community under the rules that we have set below. 

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers will work to make your participation in
our project and community as fulfilling as possible.

### Our Rules

All members of our project and community must:

1.  Show empathy toward other project and community members
2.  Use welcoming and inclusive language
3.  Respect differing viewpoints and experiences
4.  Gracefully accept constructive criticism

All members of our project and community must not:

1.  Harm our project and community, or advocate harm to our project and community
2.  Insult or make derogatory comments about others
3.  Interact with others after they have withdrawn permission to do so

### Our Responsibilities

We will use any and all lawful means at our disposal to enforce our rules. This includes
but is not limited to:

1.  Rejecting contributions
2.  Removing comments, commits, code, wiki edits, and issues
3.  Banning abusers
 
We will clarify standards of acceptable behavior and we will take appropriate
and fair corrective action in response to any instances of unacceptable behavior.

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting us at github.abuse@steemit.com. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. We
maintain strict confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/gg
