#! /bin/bash
set -e

PROJECT_URL="${1:?Missing arg #1 pointing project url. It is provided by CI_PROJECT_URL variable}"
FEATURE_BRANCH_NAME="${2:?Missing arg #2 pointing a branch name}"
FINAL_MERGE="${3:?Missing arg #3 pointing the final merge flag value}"

if [ "${FINAL_MERGE}" = "true" ]; then
  FINAL_MERGE=1
else
  FINAL_MERGE=0
fi

if [ ${FINAL_MERGE} -eq 1 ]; then
  DOC_URL="${PROJECT_URL}/-/wikis/home"
else
  DOC_URL="${PROJECT_URL}/-/wikis/non-stable/${FEATURE_BRANCH_NAME}/home"
fi

echo "Documentation url: ${DOC_URL}"

export DOC_URL="${DOC_URL}"

echo GEN_DOC_URL="${DOC_URL}" > "gen_doc.env"
