from __future__ import annotations

from typing import TYPE_CHECKING

from textual.widgets import Label

from clive.__private.core.constants.tui.texts import LOADING_TEXT
from clive.__private.ui.widgets.dynamic_widgets.dynamic_widget import (
    DynamicWidget,
    DynamicWidgetFirstTryCallbackType,
    WatchLikeCallbackType,
)

if TYPE_CHECKING:
    from textual.reactive import Reactable
    from textual.visual import VisualType

DynamicLabelCallbackType = WatchLikeCallbackType[str]


class DynamicLabel(DynamicWidget[Label, str]):
    def __init__(
        self,
        obj_to_watch: Reactable,
        attribute_name: str,
        callback: DynamicLabelCallbackType,
        *,
        first_try_callback: DynamicWidgetFirstTryCallbackType = lambda: True,
        prefix: str = "",
        init: bool = True,
        id_: str | None = None,
        classes: str | None = None,
        shrink: bool = False,
    ) -> None:
        self._shrink = shrink
        self._prefix = prefix
        super().__init__(
            obj_to_watch,
            attribute_name,
            callback,
            first_try_callback=first_try_callback,
            init=init,
            id_=id_,
            classes=classes,
        )

    @property
    def content(self) -> VisualType:
        return self._widget.content

    def _create_widget(self) -> Label:
        return Label(LOADING_TEXT, shrink=self._shrink)

    def _update_widget_state(self, result: str) -> None:
        if result != self.content:
            self._widget.update(f"{self._prefix}{result}")
