from __future__ import annotations

from typing import TYPE_CHECKING

from clive.__private.ui.widgets.inputs.numeric_input import NumericInput

if TYPE_CHECKING:
    from rich.console import RenderableType


class FeeInput(NumericInput):
    def __init__(
        self,
        label: str = "fee",
        value: float | None = None,
        *,
        placeholder: str = "",
        tooltip: RenderableType | None = None,
        disabled: bool = False,
        id_: str | None = None,
        classes: str | None = None,
    ) -> None:
        super().__init__(
            label=label,
            value=value,
            placeholder=placeholder,
            tooltip=tooltip,
            disabled=disabled,
            id_=id_,
            classes=classes,
        )
