// Vests to Hive tooltip

import {
  Tooltip,
  TooltipProvider,
  TooltipTrigger,
  TooltipContent,
} from "./ui/tooltip";

interface VestsTooltipProps {
  tooltipTrigger: string;
  tooltipContent: string;
}

const HiveTooltip: React.FC<VestsTooltipProps> = ({
  tooltipTrigger,
  tooltipContent,
}) => {
  return (
    <>
      <TooltipProvider>
        <Tooltip>
          <TooltipTrigger asChild>
            <span className="inline">{tooltipTrigger}</span>
          </TooltipTrigger>
          <TooltipContent className="bg-theme text-text border-0">
            <p>{tooltipContent}</p>
          </TooltipContent>
        </Tooltip>
      </TooltipProvider>
    </>
  );
};

export default HiveTooltip;
