from urllib.parse import urljoin

import requests

from benchmark_results_collector.post_grafana_annotations import GRAFANA_URL


def test_grafana_connection():
    assert requests.get(url=GRAFANA_URL).ok


def test_api_authorization(bearer_token):
    url = urljoin(GRAFANA_URL, '/api/org')
    assert requests.get(url=url, headers={'Authorization': f'Bearer {bearer_token}'}).ok
