import pytest


def pytest_addoption(parser):
    parser.addoption('--bearer-token', action='store', help='Grafana api key bearer token.')
    parser.addini(name="bearer_token", help='Grafana api key bearer token.')


@pytest.fixture(scope='session')
def bearer_token(pytestconfig):
    return pytestconfig.getoption('bearer_token') or pytestconfig.getini('bearer_token')
