from __future__ import annotations

from benchmark_results_collector.private import sync_log_mode
from benchmark_results_collector.private.sync_log_mode import InfoType


def test_sync_log_parsing_creating_indexes(interesting_sync_log_strings):
    parsed_objects = sync_log_mode.parse_log_strings_to_objects(
        info_type=InfoType.CREATING_INDEXES,
        interesting_log_strings=interesting_sync_log_strings[InfoType.CREATING_INDEXES],
    )

    partials = [
        sync_log_mode.DbOperation.Partial(table_name='hive_posts', total_time=2.0853),
        sync_log_mode.DbOperation.Partial(table_name='hive_votes', total_time=2.0396),
    ]

    assert parsed_objects == [
        sync_log_mode.DbOperation(info_type=InfoType.CREATING_INDEXES, total_time=4.1003, partials=partials),
    ]


def test_sync_log_parsing_filling_data(interesting_sync_log_strings: dict[InfoType, list]):
    parsed_objects = sync_log_mode.parse_log_strings_to_objects(
        info_type=InfoType.FILLING_DATA,
        interesting_log_strings=interesting_sync_log_strings[InfoType.FILLING_DATA],
    )

    partials = [
        sync_log_mode.DbOperation.Partial(table_name='hive_posts', total_time=132.9586),
        sync_log_mode.DbOperation.Partial(table_name='blocks_consistency_flag', total_time=125.6784),
    ]

    assert parsed_objects == [
        sync_log_mode.DbOperation(info_type=InfoType.FILLING_DATA, total_time=164.7935, partials=partials),
    ]


def test_sync_log_parsing_blocks_info(interesting_sync_log_strings):
    parsed_objects = sync_log_mode.parse_log_strings_to_objects(
        info_type=InfoType.BLOCKS_INFO,
        interesting_log_strings=interesting_sync_log_strings[InfoType.BLOCKS_INFO],
    )

    assert parsed_objects == [
        sync_log_mode.SyncInfo(
            range_from=1,
            range_to=1000,
            processing_n_blocks_time=0.0557,
            processing_total_time=0.169300,
            physical_memory=61.69,
            virtual_memory=1953.77,
            shared_memory=13.53,
            mem_unit='MB',
        ),
        sync_log_mode.SyncInfo(
            range_from=1001,
            range_to=4000,
            processing_n_blocks_time=0.31,
            processing_total_time=0.62,
            physical_memory=64.82,
            virtual_memory=1927.85,
            shared_memory=14.53,
            mem_unit='MB',
        ),
        sync_log_mode.SyncInfo(
            range_from=4001,
            range_to=4970,
            processing_n_blocks_time=0.2507,
            processing_total_time=0.463699,
            physical_memory=65.82,
            virtual_memory=1957.85,
            shared_memory=13.53,
            mem_unit='MB',
        ),
    ]


def test_sync_log_parsing_to_objects_wrong():
    assert sync_log_mode.parse_log_strings_to_objects(1, ['', 'abc']) == []
    assert sync_log_mode.parse_log_strings_to_objects(InfoType.CREATING_INDEXES, ['', 'abc']) == []
    assert sync_log_mode.parse_log_strings_to_objects(InfoType.FILLING_DATA, ['', 'abc']) == []
    assert sync_log_mode.parse_log_strings_to_objects(InfoType.BLOCKS_INFO, ['', 'abc']) == []
