# pylint: skip-file
# because disabling check for duplicate-code is still not working (https://github.com/PyCQA/pylint/issues/214)

from __future__ import annotations

import datetime
from pathlib import Path

import pytest

from benchmark_results_collector import collect_benchmark_results
from benchmark_results_collector.private import common, sync_log_mode
from benchmark_results_collector.private.db_adapter import Db
from tests.collect_benchmark_results_tests.constants import PATH_OF_MIXED_SYNC_LOGS, ZSCORE_LIMIT_DEFAULT


@pytest.mark.asyncio
async def test_sync_log_mode(database: Db, sql_select_all: str, startup_args: list[str], benchmark):
    time_unit = 'ms'
    mem_unit = 'MB'
    startup_args.extend(['-m', '2', '-j', '33', '-f', str(PATH_OF_MIXED_SYNC_LOGS)])

    args = collect_benchmark_results.init_argparse(startup_args)
    timestamp = datetime.datetime.now()

    await common.insert_benchmark_description(database=database, args=args, timestamp=timestamp)
    await sync_log_mode.main(
        database=database,
        file=Path(args.file),
        benchmark_id=args.job_id,
        measurement_timestamp=timestamp,
    )

    actual = await database.query_all(sql_select_all)

    benchmark = benchmark(timestamp=timestamp)

    # fmt: off
    creating_indexes_cpu_time1 = ('hivemind_indexer', 'creating_indexes_cpu_time',
                                  '{"table_name": "hive_posts"}',
                                  '6a7d671e12fe84aa8e0edfb4f2118c00d6da1366af9d642fcfe19ce29ea97a97')

    creating_indexes_cpu_time2 = ('hivemind_indexer', 'creating_indexes_cpu_time',
                                  '{"table_name": "hive_votes"}',
                                  'e504e9508ddd385e3a73a74ce5ce0658786fdef37043ede7ffcbf0b16be7ce52')

    filling_data_cpu_time1 = ('hivemind_indexer', 'filling_data_cpu_time',
                              '{"table_name": "hive_posts"}',
                              'b99cb5bafdcca1403a9fba90a860a4d8df59f1dbcc66d8ff11a7b014bd7ff6fa')

    filling_data_cpu_time2 = ('hivemind_indexer', 'filling_data_cpu_time',
                              '{"table_name": "blocks_consistency_flag"}',
                              '8669bcb477c1af8814a7b96eb8bfcd86058f6976ce396d50cea3c40853c17b6a')

    creating_indexes_real_time = ('hivemind_indexer', 'creating_indexes_real_time',
                                  '',
                                  '2d16fc5ed28825b373c0a3660a300f64b1dfc037bbba9c7ea74b8ff9233137ab')

    processing_1000_blocks_real_time = ('hivemind_indexer', 'processing_1000_blocks_real_time',
                                        '{"from": 1, "to": 1000}',
                                        'a89346d73e1c2449394b79dd37c1dc5091a53bfcd4bc1d928241694bca905b0d')

    processing_blocks_total_real_time1 = ('hivemind_indexer', 'processing_blocks_total_real_time',
                                          '{"block": 1000}',
                                          'c95b5d6179fe556d9242b09d28b7dff3fe778707a84ca07505bb9da908e9ded9')

    memory_usage_physical1 = ('hivemind_indexer', 'memory_usage_physical',
                              '{"block": 1000}',
                              '8af014fa839affbd6929f465cfe48582d7057ba48042b5262a3d678ada6541f3')

    memory_usage_virtual1 = ('hivemind_indexer', 'memory_usage_virtual',
                             '{"block": 1000}',
                             'c8d043c5fcf62ccca40ea8a01239a780c1b12dd5680db49da73ebe6d04e204d9')

    memory_usage_shared1 = ('hivemind_indexer', 'memory_usage_shared',
                            '{"block": 1000}',
                            '6d8dceae83485a205054257774666282d24b53345cfbc6785ff5029c712df22f')

    processing_3000_blocks_real_time = ('hivemind_indexer', 'processing_3000_blocks_real_time',
                                        '{"from": 1001, "to": 4000}',
                                        'fb2b11022b44a4272d42a5619a7724a3abb0f5550b9bf7f1d6a1f9546cf2dadb')

    processing_blocks_total_real_time2 = ('hivemind_indexer', 'processing_blocks_total_real_time',
                                          '{"block": 4000}',
                                          '695ea1e6807702c3f8fb980f7380d99ffa9a2004a8c5f1223715dbcc2d9eded5')

    memory_usage_physical2 = ('hivemind_indexer', 'memory_usage_physical',
                              '{"block": 4000}',
                              '766e38bbbeb5ecde19e9fdba5f5115a2f1f06fe932a35ab0d22f3e3dbdbbc8a0')

    memory_usage_virtual2 = ('hivemind_indexer', 'memory_usage_virtual',
                             '{"block": 4000}',
                             '59a33d8e30f364ff1bab5c8d8c1d9d3c9acce327b4384e4beaa6370d08004868')

    memory_usage_shared2 = ('hivemind_indexer', 'memory_usage_shared',
                            '{"block": 4000}',
                            '25fbf6f01b1e70c097117b482203f1befb099f0f66b0eb0b5b2d4371f3802487')

    processing_970_blocks_real_time = ('hivemind_indexer', 'processing_970_blocks_real_time',
                                       '{"from": 4001, "to": 4970}',
                                       '4d69a5c015f0b8bee28caa7832594a9b7ef4a744795d6ac62c215b600fefaa0e')

    processing_blocks_total_real_time3 = ('hivemind_indexer', 'processing_blocks_total_real_time',
                                          '{"block": 4970}',
                                          '9d931a7ba93dede565abf1530c3552bb67fc808b5a10adbb611a0d08b88f4402')
    memory_usage_physical3 = ('hivemind_indexer', 'memory_usage_physical',
                              '{"block": 4970}',
                              'c1c75688156e75cdd15a5ffc56a41668d21ce61870b65bddc70102ce1953b5c1')

    memory_usage_virtual3 = ('hivemind_indexer', 'memory_usage_virtual',
                             '{"block": 4970}',
                             '1d1d248211691368aa441a64ff6ad77b2709ab2af9e94d74f6edb27a60fd7165')

    memory_usage_shared3 = ('hivemind_indexer', 'memory_usage_shared',
                            '{"block": 4970}',
                            '16c0bc86c3753da8fd2acf6cea2b3a04efc98b6bd009789b84e28bc634dac3fd')

    filling_data_real_time = ('hivemind_indexer', 'filling_data_real_time',
                              '',
                              'd8f9040bcd74c9aec91506b331f5a713d1ce390c47e75c40fcaed707a0f2d84b')

    assert actual == [
        (*benchmark, *creating_indexes_cpu_time1, ZSCORE_LIMIT_DEFAULT, timestamp, 2085, time_unit),
        (*benchmark, *creating_indexes_cpu_time2, ZSCORE_LIMIT_DEFAULT, timestamp, 2040, time_unit),
        (*benchmark, *creating_indexes_real_time, ZSCORE_LIMIT_DEFAULT, timestamp, 4100, time_unit),

        (*benchmark, *processing_1000_blocks_real_time, ZSCORE_LIMIT_DEFAULT, timestamp, 56, time_unit),
        (*benchmark, *processing_blocks_total_real_time1, ZSCORE_LIMIT_DEFAULT, timestamp, 169, time_unit),
        (*benchmark, *memory_usage_physical1, ZSCORE_LIMIT_DEFAULT, timestamp, 62, mem_unit),
        (*benchmark, *memory_usage_virtual1, ZSCORE_LIMIT_DEFAULT, timestamp, 1954, mem_unit),
        (*benchmark, *memory_usage_shared1, ZSCORE_LIMIT_DEFAULT, timestamp, 14, mem_unit),

        (*benchmark, *processing_3000_blocks_real_time, ZSCORE_LIMIT_DEFAULT, timestamp, 310, time_unit),
        (*benchmark, *processing_blocks_total_real_time2, ZSCORE_LIMIT_DEFAULT, timestamp, 620, time_unit),
        (*benchmark, *memory_usage_physical2, ZSCORE_LIMIT_DEFAULT, timestamp, 65, mem_unit),
        (*benchmark, *memory_usage_virtual2, ZSCORE_LIMIT_DEFAULT, timestamp, 1928, mem_unit),
        (*benchmark, *memory_usage_shared2, ZSCORE_LIMIT_DEFAULT, timestamp, 15, mem_unit),

        (*benchmark, *processing_970_blocks_real_time, ZSCORE_LIMIT_DEFAULT, timestamp, 251, time_unit),
        (*benchmark, *processing_blocks_total_real_time3, ZSCORE_LIMIT_DEFAULT, timestamp, 464, time_unit),
        (*benchmark, *memory_usage_physical3, ZSCORE_LIMIT_DEFAULT, timestamp, 66, mem_unit),
        (*benchmark, *memory_usage_virtual3, ZSCORE_LIMIT_DEFAULT, timestamp, 1958, mem_unit),
        (*benchmark, *memory_usage_shared3, ZSCORE_LIMIT_DEFAULT, timestamp, 14, mem_unit),

        (*benchmark, *filling_data_cpu_time1, ZSCORE_LIMIT_DEFAULT, timestamp, 132959, time_unit),
        (*benchmark, *filling_data_cpu_time2, ZSCORE_LIMIT_DEFAULT, timestamp, 125678, time_unit),
        (*benchmark, *filling_data_real_time, ZSCORE_LIMIT_DEFAULT, timestamp, 164794, time_unit),
    ]
