from __future__ import annotations

from benchmark_results_collector.private import server_log_mode
from benchmark_results_collector.private.common import DbData
from tests.collect_benchmark_results_tests.constants import PATH_OF_INVALID_SERVER_LOGS, PATH_OF_MIXED_SERVER_LOGS


def test_server_log_parsing_and_mapping(mock_mapped_list: list[DbData]):
    with open(PATH_OF_MIXED_SERVER_LOGS, 'r', encoding='utf-8') as file:
        log_lines = file.readlines()
    assert server_log_mode.parse_and_map_log_lines(log_lines) == mock_mapped_list


def test_server_log_empty_lines_parsing_and_mapping():
    assert server_log_mode.parse_and_map_log_lines(['', '', '']) == []


def test_server_log_invalid_lines_parsing_and_mapping():
    with open(PATH_OF_INVALID_SERVER_LOGS, 'r', encoding='utf-8') as file:
        log_lines = file.readlines()
    assert server_log_mode.parse_and_map_log_lines(log_lines) == []
