# pylint: skip-file
# because disabling check for duplicate-code is still not working (https://github.com/PyCQA/pylint/issues/214)

from __future__ import annotations

import datetime as dt
from pathlib import Path

from benchmark_results_collector import collect_benchmark_results
from benchmark_results_collector.private import common, server_log_mode
from benchmark_results_collector.private.db_adapter import Db
import pytest
from tests.collect_benchmark_results_tests.constants import PATH_OF_MIXED_SERVER_LOGS, ZSCORE_LIMIT_DEFAULT


@pytest.mark.asyncio
async def test_server_log_mode(
    database: Db, sql_select_all: str, startup_args: list[str], testcase_timestamps: dict[str, dt.datetime], benchmark
):
    time_unit = 'ms'
    startup_args.extend(['-m', '1', '-f', str(PATH_OF_MIXED_SERVER_LOGS)])

    args = collect_benchmark_results.init_argparse(startup_args)
    timestamp = dt.datetime.now()

    await common.insert_benchmark_description(database=database, args=args, timestamp=timestamp)
    await server_log_mode.main(database=database, file=Path(args.file), benchmark_id=args.job_id)

    actual = await database.query_all(sql_select_all)

    benchmark = benchmark(timestamp=timestamp)

    # fmt: off
    testcase1 = ('bridge', 'get_account_posts',
                 '{"sort": "replies", "account": "gtg", "observer": "gtg"}',
                 '6e1d6e836a45438f7e8c130f8f85a2cdacf81ab7d0b5fae4875d4ed2f083cd4a')
    testcase2 = ('bridge',
                 'get_community', '{"name": "hive-135485"}',
                 '60db22f04dfe57632c5ac6b03a154caeb16db50a87d2be9670a525d5c57637f1')
    testcase3 = ('bridge', 'get_account_posts',
                 '{"sort": "blog", "account": "steemit"}',
                 'e67acec4eef88c4e462efea6846004ad0487d20982f537d4e7bd87da3b50d730')

    assert actual == [
        (*benchmark, *testcase1, ZSCORE_LIMIT_DEFAULT, testcase_timestamps['1'], 74, time_unit),
        (*benchmark, *testcase1, ZSCORE_LIMIT_DEFAULT, testcase_timestamps['2'], 74, time_unit),
        (*benchmark, *testcase1, ZSCORE_LIMIT_DEFAULT, testcase_timestamps['3'], 74, time_unit),
        (*benchmark, *testcase2, ZSCORE_LIMIT_DEFAULT, testcase_timestamps['4'], 15, time_unit),
        (*benchmark, *testcase3, ZSCORE_LIMIT_DEFAULT, testcase_timestamps['5'], 26, time_unit),
    ]
