import datetime as dt

from benchmark_results_collector.private import server_log_mode


def test_server_log_single_line_parsing_format1():
    line = (
        '1645112818198 Request: {"jsonrpc": "2.0", "id": 1, "method": "bridge.get_ranked_posts", '
        '"params": {"sort": "payout", "tag": "all", "observer": "joeyarnoldvn", "limit": 5}} processed in 0.0058s'
    )
    parsed = server_log_mode.parse_log_line(line)

    assert parsed['measurement_timestamp'] == dt.datetime(2022, 2, 17, 15, 46, 58, 198000)
    assert parsed['caller'] == 'bridge'
    assert parsed['method'] == 'get_ranked_posts'
    assert parsed['params'] == '{"sort": "payout", "tag": "all", "observer": "joeyarnoldvn", "limit": 5}'
    assert parsed['value'] == 6
    assert parsed['unit'] == 'ms'


def test_server_log_single_line_parsing_format2():
    line = (
        '1645112818465 Request: {"jsonrpc": "2.0", "id": "b8d63786-b314-4a36-b5ed-331f75210447", '
        '"method": "bridge.get_payout_stats", "params": [10]} processed in 0.0072s'
    )
    parsed = server_log_mode.parse_log_line(line)

    assert parsed['measurement_timestamp'] == dt.datetime(2022, 2, 17, 15, 46, 58, 465000)
    assert parsed['caller'] == 'bridge'
    assert parsed['method'] == 'get_payout_stats'
    assert parsed['params'] == '[10]'
    assert parsed['value'] == 7
    assert parsed['unit'] == 'ms'


def test_server_log_single_line_parsing_format3():
    line = (
        '1645112818267 Request: {"jsonrpc": "2.0", "id": 1, "method": "call", '
        '"params": {"api": "condenser_api", "method": "get_account_votes", "params": ["gtg"]}} processed in 0.0012s'
    )
    parsed = server_log_mode.parse_log_line(line)

    assert parsed['measurement_timestamp'] == dt.datetime(2022, 2, 17, 15, 46, 58, 267000)
    assert parsed['caller'] == 'condenser_api'
    assert parsed['method'] == 'get_account_votes'
    assert parsed['params'] == '["gtg"]'
    assert parsed['value'] == 1
    assert parsed['unit'] == 'ms'


def test_server_log_single_line_parsing_format4():
    line = (
        '1645112818673 Request: {"jsonrpc": "2.0", "id": 1, "method": "call", '
        '"params": ["bridge_api", "account_notifications", ["steemit", 15, 20]]} processed in 0.0015s'
    )
    parsed = server_log_mode.parse_log_line(line)

    assert parsed['measurement_timestamp'] == dt.datetime(2022, 2, 17, 15, 46, 58, 673000)
    assert parsed['caller'] == 'bridge_api'
    assert parsed['method'] == 'account_notifications'
    assert parsed['params'] == '["steemit", 15, 20]'
    assert parsed['value'] == 2
    assert parsed['unit'] == 'ms'


def test_empty_server_log_line_parsing():
    assert server_log_mode.parse_log_line('') is None


def test_wrong_server_log_line_parsing():
    line = (
        'INFO - Request-Process-Time-Logger - '
        'Request: {"jsonrpc": "2.0", "id": 1, "method": "bridge.get_ranked_posts", '
        '"params": {"sort": "created", "tag": "hive-135485", "start_author": "", '
        '"start_permlink": "pinpost11", "limit": 1}} processed in 0.0020s'
    )
    assert server_log_mode.parse_log_line(line) is None
