# pylint: skip-file
# because disabling check for duplicate-code is still not working (https://github.com/PyCQA/pylint/issues/214)

from __future__ import annotations

import datetime as dt
from pathlib import Path
from typing import Final

import pytest

from benchmark_results_collector import collect_benchmark_results
from benchmark_results_collector.private import common, replay_benchmark_mode
from benchmark_results_collector.private.db_adapter import Db
from tests.collect_benchmark_results_tests.constants import PATH_OF_SAMPLE_REPLAY_LOGS, ZSCORE_LIMIT_DEFAULT
from tests.constants import DATETIME_UTC

DATETIME: Final[dt.datetime] = DATETIME_UTC.replace(tzinfo=None)


def measurement_testcase(method: str, params: str) -> tuple:
    caller = 'replay_benchmark'
    return (
        caller,
        method,
        params,
        common.DbData.calculate_hash(caller, method, params),
        ZSCORE_LIMIT_DEFAULT,
        DATETIME,
    )


def index_testcase(method: str, params: str) -> tuple:
    caller = 'replay_benchmark_index_memory_detail'
    return (
        caller,
        method,
        params,
        common.DbData.calculate_hash(caller, method, params),
        ZSCORE_LIMIT_DEFAULT,
        DATETIME,
    )


@pytest.mark.asyncio
async def test_replay_benchmark_mode(database: Db, sql_select_all: str, startup_args: list[str], benchmark):
    startup_args.extend(['-m', '1', '-f', str(PATH_OF_SAMPLE_REPLAY_LOGS)])

    args = collect_benchmark_results.init_argparse(startup_args)

    await common.insert_benchmark_description(database=database, args=args, timestamp=DATETIME)
    await replay_benchmark_mode.main(
        database=database,
        file=Path(args.file),
        benchmark_id=args.job_id,
        measurement_timestamp=DATETIME,
    )

    actual = await database.query_all(sql_select_all)

    benchmark = benchmark(timestamp=DATETIME)

    # fmt: off
    partial_measurement_real_time1 = measurement_testcase('partial_measurement_real_time', '{"block": 100000}')
    partial_measurement_cpu_time1 = measurement_testcase('partial_measurement_cpu_time', '{"block": 100000}')
    partial_measurement_current_memory_usage1 = measurement_testcase('partial_measurement_current_memory_usage',
                                                                     '{"block": 100000}')
    partial_measurement_peak_memory_usage1 = measurement_testcase('partial_measurement_peak_memory_usage',
                                                                  '{"block": 100000}')
    partial_measurement_hive_chain_dynamic_global_property_object_index_size1 = index_testcase(
        'partial_measurement_hive_chain_dynamic_global_property_object_index_size',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_dynamic_global_property_object_item_sizeof1 = index_testcase(
        'partial_measurement_hive_chain_dynamic_global_property_object_item_sizeof',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_dynamic_global_property_object_total_index_mem_usage1 = index_testcase(
        'partial_measurement_hive_chain_dynamic_global_property_object_total_index_mem_usage',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_account_object_index_size = index_testcase(
        'partial_measurement_hive_chain_account_object_index_size',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_account_object_item_sizeof = index_testcase(
        'partial_measurement_hive_chain_account_object_item_sizeof',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_account_object_total_index_mem_usage = index_testcase(
        'partial_measurement_hive_chain_account_object_total_index_mem_usage',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_account_metadata_object_index_size = index_testcase(
        'partial_measurement_hive_chain_account_metadata_object_index_size',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_account_metadata_object_item_sizeof = index_testcase(
        'partial_measurement_hive_chain_account_metadata_object_item_sizeof',
        '{"block": 100000}',
    )
    partial_measurement_hive_chain_account_metadata_object_total_index_mem_usage = index_testcase(
        'partial_measurement_hive_chain_account_metadata_object_total_index_mem_usage',
        '{"block": 100000}',
    )

    partial_measurement_real_time2 = measurement_testcase('partial_measurement_real_time', '{"block": 200000}')
    partial_measurement_cpu_time2 = measurement_testcase('partial_measurement_cpu_time', '{"block": 200000}')
    partial_measurement_current_memory_usage2 = measurement_testcase('partial_measurement_current_memory_usage',
                                                                     '{"block": 200000}')
    partial_measurement_peak_memory_usage2 = measurement_testcase('partial_measurement_peak_memory_usage',
                                                                  '{"block": 200000}')
    partial_measurement_hive_chain_dynamic_global_property_object_index_size2 = index_testcase(
        'partial_measurement_hive_chain_dynamic_global_property_object_index_size',
        '{"block": 200000}',
    )
    partial_measurement_hive_chain_dynamic_global_property_object_item_sizeof2 = index_testcase(
        'partial_measurement_hive_chain_dynamic_global_property_object_item_sizeof',
        '{"block": 200000}',
    )
    partial_measurement_hive_chain_dynamic_global_property_object_total_index_mem_usage2 = index_testcase(
        'partial_measurement_hive_chain_dynamic_global_property_object_total_index_mem_usage',
        '{"block": 200000}',
    )

    total_measurement_real_time = measurement_testcase('total_measurement_real_time', '{"block": 5000000}')
    total_measurement_cpu_time = measurement_testcase('total_measurement_cpu_time', '{"block": 5000000}')
    total_measurement_current_memory_usage = measurement_testcase('total_measurement_current_memory_usage',
                                                                  '{"block": 5000000}')
    total_measurement_peak_memory_usage = measurement_testcase('total_measurement_peak_memory_usage',
                                                               '{"block": 5000000}')
    total_measurement_hive_chain_comment_cashout_object_index_size = index_testcase(
        'total_measurement_hive_chain_comment_cashout_object_index_size',
        '{"block": 5000000}',
    )
    total_measurement_hive_chain_comment_cashout_object_item_sizeof = index_testcase(
        'total_measurement_hive_chain_comment_cashout_object_item_sizeof',
        '{"block": 5000000}',
    )
    total_measurement_hive_chain_comment_cashout_object_total_index_mem_usage = index_testcase(
        'total_measurement_hive_chain_comment_cashout_object_total_index_mem_usage',
        '{"block": 5000000}',
    )

    assert actual == [
        (*benchmark, *partial_measurement_real_time1, 451206, 'ms'),
        (*benchmark, *partial_measurement_cpu_time1, 167582, 'ms'),
        (*benchmark, *partial_measurement_current_memory_usage1, 25969088, 'kB'),
        (*benchmark, *partial_measurement_peak_memory_usage1, 526610236, 'kB'),
        (*benchmark, *partial_measurement_hive_chain_dynamic_global_property_object_index_size1, 1, 'B'),
        (*benchmark, *partial_measurement_hive_chain_dynamic_global_property_object_item_sizeof1, 368, 'B'),
        (*benchmark, *partial_measurement_hive_chain_dynamic_global_property_object_total_index_mem_usage1, 400, 'B'),
        (*benchmark, *partial_measurement_hive_chain_account_object_index_size, 398, 'B'),
        (*benchmark, *partial_measurement_hive_chain_account_object_item_sizeof, 424, 'B'),
        (*benchmark, *partial_measurement_hive_chain_account_object_total_index_mem_usage, 245168, 'B'),
        (*benchmark, *partial_measurement_hive_chain_account_metadata_object_index_size, 394, 'B'),
        (*benchmark, *partial_measurement_hive_chain_account_metadata_object_item_sizeof, 72, 'B'),
        (*benchmark, *partial_measurement_hive_chain_account_metadata_object_total_index_mem_usage, 53584, 'B'),

        (*benchmark, *partial_measurement_real_time2, 671, 'ms'),
        (*benchmark, *partial_measurement_cpu_time2, 671, 'ms'),
        (*benchmark, *partial_measurement_current_memory_usage2, 25969088, 'kB'),
        (*benchmark, *partial_measurement_peak_memory_usage2, 526610236, 'kB'),
        (*benchmark, *partial_measurement_hive_chain_dynamic_global_property_object_index_size2, 1, 'B'),
        (*benchmark, *partial_measurement_hive_chain_dynamic_global_property_object_item_sizeof2, 368, 'B'),
        (*benchmark, *partial_measurement_hive_chain_dynamic_global_property_object_total_index_mem_usage2, 400, 'B'),

        (*benchmark, *total_measurement_real_time, 877896, 'ms'),
        (*benchmark, *total_measurement_cpu_time, 560396, 'ms'),
        (*benchmark, *total_measurement_current_memory_usage, 7183280, 'kB'),
        (*benchmark, *total_measurement_peak_memory_usage, 7183280, 'kB'),
        (*benchmark, *total_measurement_hive_chain_comment_cashout_object_index_size, 951749, 'B'),
        (*benchmark, *total_measurement_hive_chain_comment_cashout_object_item_sizeof, 128, 'B'),
        (*benchmark, *total_measurement_hive_chain_comment_cashout_object_total_index_mem_usage, 291137992, 'B'),
    ]
