#!/bin/bash
set -euo pipefail

run_collector() {
  python3 benchmark_results_collector/collect_benchmark_results.py \
  -m $MODE \
  -j $JOB_ID \
  -f "artifacts/$LOG_PATH" \
  -db postgresql://$USER:$PASS@$HOST:$PORT/$NAME \
  --desc "$DESC" \
  --exec-env-desc "$EXEC_ENV_DESC" \
  --server-name "$SERVER_NAME" \
  --app-version "$APP_VERSION" \
  --testsuite-version "$TESTSUITE_VERSION"
}

main() {
  echo [ Launching collector in SOURCE=$SOURCE mode ]
  pip install .

  if [ "$SOURCE" = "hivemind" ]; then
    MODE=1
    LOG_PATH="request_process_times.log"
    run_collector
    MODE=2
    LOG_PATH="hivemind-sync.log"
    run_collector
  elif [ "$SOURCE" = "hived" ] || [ "$SOURCE" = "haf" ]; then
    MODE=3
    LOG_PATH="replay_benchmark.json"
    run_collector
  else
    echo "Invalid SOURCE argument (Available modes: \"hivemind\", \"hived\", \"haf\")"
    exit 1
  fi
}

main
