CREATE OR REPLACE FUNCTION get_testcase_zscore(p_hash testcase.hash % TYPE, p_interval INTERVAL, desc_like TEXT, exec_env_desc_like TEXT)
RETURNS TABLE (measurement_timestamp timestamp without time zone, job_id BIGINT, last_value BIGINT, avg_value NUMERIC, stddev_value NUMERIC, z_score NUMERIC)
AS $$
   WITH measurement AS(
        WITH considered AS(
            (SELECT measurement_timestamp,
                    job_id,
                    value
            FROM benchmark_results_collector_merged
            WHERE hash=p_hash
            ORDER BY measurement_timestamp DESC
            LIMIT 1)
            UNION
            (SELECT measurement_timestamp,
                    job_id,
                    value
            FROM benchmark_results_collector_merged
            WHERE hash=p_hash
            AND description ILIKE desc_like
            AND execution_environment_description ILIKE exec_env_desc_like
			AND measurement_timestamp > now() - p_interval
            ORDER BY measurement_timestamp DESC)
            ORDER BY measurement_timestamp DESC)
        SELECT 	(MAX(ARRAY[EXTRACT('epoch' FROM measurement_timestamp), job_id, value])) AS last,
                AVG(value) as avg_value,
                STDDEV_SAMP(value) as stddev_value
        FROM considered)
    SELECT	to_timestamp(last[1]) AT TIME ZONE 'utc' as measurement_timestamp,
            last[2]::BIGINT as job_id,
            last[3]::BIGINT as last_value,
            avg_value,
            stddev_value,
            ((last[3] - avg_value) / NULLIF(stddev_value::float, 0))::NUMERIC as z_score
    FROM measurement;
$$ LANGUAGE SQL;


