from __future__ import annotations

from email import encoders
from email.mime.base import MIMEBase
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import formatdate
from pathlib import Path
import smtplib
from typing import Optional


class SMTP:
    def __init__(self, server: str, port: int = 587, use_tls: bool = True, username: str = '', password: str = ''):
        # pylint: disable=too-many-arguments

        self.__smtp = smtplib.SMTP(server, port)

        if use_tls:
            self.__smtp.starttls()

        self.__smtp.login(username, password)

    def send_mail(
        self, send_from: str, send_to: list[str], subject: str, message: str, files: Optional[list[Path]] = None
    ) -> None:
        # pylint: disable=too-many-arguments

        files = [] if not files else files

        msg = MIMEMultipart()
        msg['From'] = send_from
        msg['To'] = ', '.join(send_to)
        msg['Date'] = formatdate(localtime=True)
        msg['Subject'] = subject

        msg.attach(MIMEText(message, 'html'))

        for path in files:
            part = MIMEBase('application', "octet-stream")
            with open(path, 'rb') as file:
                part.set_payload(file.read())
            encoders.encode_base64(part)
            part.add_header('Content-Disposition', f'attachment; filename={path.name}')
            msg.attach(part)

        self.__smtp.sendmail(send_from, send_to, msg.as_string())

    def close(self):
        self.__smtp.quit()
