import logging
import sys
from typing import Union

FORMATTER = logging.Formatter('%(levelname)s:(%(filename)s:%(lineno)s) | %(message)s')


def logger_setup(level: Union[int, str] = logging.INFO):
    stream_handler = logging.StreamHandler(sys.stdout)
    stream_handler.setFormatter(FORMATTER)
    stream_handler.setLevel(logging.DEBUG)

    logger = logging.getLogger('benchmark_results_collector')
    logger.addHandler(stream_handler)
    logger.setLevel(level)
