from __future__ import annotations

from pathlib import Path
import socket
import subprocess
from typing import Final

ROOT_PATH: Final = Path(__file__).parent.parent

MODE: Final[int] = 3
DESC: Final[str] = 'Alerts testing'
EXEC_ENV_DESC: Final[str] = ''
SERVER_NAME: Final[str] = socket.gethostname()
APP_VERSION: Final[str] = ''
TESTSUITE_VERSION: Final[str] = ''

POSTGRES_HOST: Final[str] = 'localhost'
POSTGRES_PORT: Final[int] = 5432
POSTGRES_USER: Final[str] = 'postgres'
POSTGRES_PASSWORD: Final[str] = 'devdevdev'
POSTGRES_DBNAME: Final[str] = 'benchmark_results'

EXT: Final[list[str]] = ['.txt', '.log', '.json']
FILES_FOLDER: Final[Path] = Path('../files')


def runtime_args() -> dict:
    return {
        '-m': str(MODE),
        '-db': f'postgresql://{POSTGRES_USER}:{POSTGRES_PASSWORD}@{POSTGRES_HOST}:{POSTGRES_PORT}/{POSTGRES_DBNAME}',
        '--desc': DESC,
        '--exec-env-desc': EXEC_ENV_DESC,
        '--server-name': SERVER_NAME,
        '--app-version': APP_VERSION,
        '--testsuite-version': TESTSUITE_VERSION,
    }


def main():
    files = sorted(filter(lambda path: path.suffix in EXT, FILES_FOLDER.glob('*')))

    args = runtime_args()

    for file in files:
        specific = {'-j': str(file.stem), '-f': str(file)}
        args.update(specific)

        args_list = list(sum(args.items(), ()))  # convert list of tuples to flat list
        print(args_list)

        subprocess.run(['python3', ROOT_PATH / 'benchmark_results_collector/main.py', *args_list], check=True)


if __name__ == '__main__':
    main()
