import time
import unittest
from steempy import Steem, exceptions
from steempy.instance import set_shared_steem_instance
from steempy.blockchainobject import ObjectCache
# steem_node = "wss://gtg.steem.house:8090"
steem_node = "wss://steemd.pevo.science"


class Testcases(unittest.TestCase):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.bts = Steem(
            steem_node,
            nobroadcast=True,
        )
        set_shared_steem_instance(self.bts)

    def test_cache(self):
        cache = ObjectCache(default_expiration=1)
        self.assertEqual(str(cache), "ObjectCache(n=0, default_expiration=1)")

        # Data
        cache["foo"] = "bar"
        self.assertIn("foo", cache)
        self.assertEqual(cache["foo"], "bar")
        self.assertEqual(cache.get("foo", "New"), "bar")

        # Expiration
        time.sleep(2)
        self.assertNotIn("foo", cache)

        # Get
        self.assertEqual(cache.get("foo", "New"), "New")
