/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
var showControllersOnly = false;
var seriesFilter = "";
var filtersOnlySampleSeries = true;

/*
 * Add header in statistics table to group metrics by category
 * format
 *
 */
function summaryTableHeader(header) {
    var newRow = header.insertRow(-1);
    newRow.className = "tablesorter-no-sort";
    var cell = document.createElement('th');
    cell.setAttribute("data-sorter", false);
    cell.colSpan = 1;
    cell.innerHTML = "Requests";
    newRow.appendChild(cell);

    cell = document.createElement('th');
    cell.setAttribute("data-sorter", false);
    cell.colSpan = 3;
    cell.innerHTML = "Executions";
    newRow.appendChild(cell);

    cell = document.createElement('th');
    cell.setAttribute("data-sorter", false);
    cell.colSpan = 7;
    cell.innerHTML = "Response Times (ms)";
    newRow.appendChild(cell);

    cell = document.createElement('th');
    cell.setAttribute("data-sorter", false);
    cell.colSpan = 1;
    cell.innerHTML = "Throughput";
    newRow.appendChild(cell);

    cell = document.createElement('th');
    cell.setAttribute("data-sorter", false);
    cell.colSpan = 2;
    cell.innerHTML = "Network (KB/sec)";
    newRow.appendChild(cell);
}

/*
 * Populates the table identified by id parameter with the specified data and
 * format
 *
 */
function createTable(table, info, formatter, defaultSorts, seriesIndex, headerCreator) {
    var tableRef = table[0];

    // Create header and populate it with data.titles array
    var header = tableRef.createTHead();

    // Call callback is available
    if(headerCreator) {
        headerCreator(header);
    }

    var newRow = header.insertRow(-1);
    for (var index = 0; index < info.titles.length; index++) {
        var cell = document.createElement('th');
        cell.innerHTML = info.titles[index];
        newRow.appendChild(cell);
    }

    var tBody;

    // Create overall body if defined
    if(info.overall){
        tBody = document.createElement('tbody');
        tBody.className = "tablesorter-no-sort";
        tableRef.appendChild(tBody);
        var newRow = tBody.insertRow(-1);
        var data = info.overall.data;
        for(var index=0;index < data.length; index++){
            var cell = newRow.insertCell(-1);
            cell.innerHTML = formatter ? formatter(index, data[index]): data[index];
        }
    }

    // Create regular body
    tBody = document.createElement('tbody');
    tableRef.appendChild(tBody);

    var regexp;
    if(seriesFilter) {
        regexp = new RegExp(seriesFilter, 'i');
    }
    // Populate body with data.items array
    for(var index=0; index < info.items.length; index++){
        var item = info.items[index];
        if((!regexp || filtersOnlySampleSeries && !info.supportsControllersDiscrimination || regexp.test(item.data[seriesIndex]))
                &&
                (!showControllersOnly || !info.supportsControllersDiscrimination || item.isController)){
            if(item.data.length > 0) {
                var newRow = tBody.insertRow(-1);
                for(var col=0; col < item.data.length; col++){
                    var cell = newRow.insertCell(-1);
                    cell.innerHTML = formatter ? formatter(col, item.data[col]) : item.data[col];
                }
            }
        }
    }

    // Add support of columns sort
    table.tablesorter({sortList : defaultSorts});
}

$(document).ready(function() {

    // Customize table sorter default options
    $.extend( $.tablesorter.defaults, {
        theme: 'blue',
        cssInfoBlock: "tablesorter-no-sort",
        widthFixed: true,
        widgets: ['zebra']
    });

    var data = {"OkPercent": 99.93593850096092, "KoPercent": 0.06406149903907751};
    var dataset = [
        {
            "label" : "FAIL",
            "data" : data.KoPercent,
            "color" : "#FF6347"
        },
        {
            "label" : "PASS",
            "data" : data.OkPercent,
            "color" : "#9ACD32"
        }];
    $.plot($("#flot-requests-summary"), dataset, {
        series : {
            pie : {
                show : true,
                radius : 1,
                label : {
                    show : true,
                    radius : 3 / 4,
                    formatter : function(label, series) {
                        return '<div style="font-size:8pt;text-align:center;padding:2px;color:white;">'
                            + label
                            + '<br/>'
                            + Math.round10(series.percent, -2)
                            + '%</div>';
                    },
                    background : {
                        opacity : 0.5,
                        color : '#000'
                    }
                }
            }
        },
        legend : {
            show : true
        }
    });

    // Creates APDEX table
    createTable($("#apdexTable"), {"supportsControllersDiscrimination": true, "overall": {"data": [0.9989990390775144, 500, 1500, "Total"], "isController": false}, "titles": ["Apdex", "T (Toleration threshold)", "F (Frustration threshold)", "Label"], "items": [{"data": [1.0, 500, 1500, "get_history_aggregation by_year"], "isController": false}, {"data": [1.0, 500, 1500, "get_balance"], "isController": false}, {"data": [1.0, 500, 1500, "get_balance_history by_time hive"], "isController": false}, {"data": [1.0, 500, 1500, "get_balance_history by_time vest"], "isController": false}, {"data": [1.0, 500, 1500, "get_btracker_last_synced_block"], "isController": false}, {"data": [1.0, 500, 1500, "get_transfer_statistics by_month"], "isController": false}, {"data": [0.9998697916666667, 500, 1500, "get_total_value_locked"], "isController": false}, {"data": [1.0, 500, 1500, "get_history_aggregation by_day"], "isController": false}, {"data": [1.0, 500, 1500, "get_history_aggregation by_month"], "isController": false}, {"data": [1.0, 500, 1500, "GET /top-holders (HBD)"], "isController": false}, {"data": [1.0, 500, 1500, "GET /top-holders (HIVE)"], "isController": false}, {"data": [1.0, 500, 1500, "get_delegations"], "isController": false}, {"data": [1.0, 500, 1500, "get_balance_history by_time hbd"], "isController": false}, {"data": [1.0, 500, 1500, "get_recurrent_transfers"], "isController": false}, {"data": [0.9916666666666667, 500, 1500, "get_transfer_statistics by_hour"], "isController": false}, {"data": [1.0, 500, 1500, "get_transfer_statistics by_year"], "isController": false}, {"data": [0.0, 500, 1500, "get_balance_history by_block hive"], "isController": false}, {"data": [1.0, 500, 1500, "GET /top-holders (VESTS)"], "isController": false}, {"data": [1.0, 500, 1500, "get_btracker_version"], "isController": false}, {"data": [1.0, 500, 1500, "get_transfer_statistics by_day"], "isController": false}]}, function(index, item){
        switch(index){
            case 0:
                item = item.toFixed(3);
                break;
            case 1:
            case 2:
                item = formatDuration(item);
                break;
        }
        return item;
    }, [[0, 0]], 3);

    // Create statistics table
    createTable($("#statisticsTable"), {"supportsControllersDiscrimination": true, "overall": {"data": ["Total", 12488, 8, 0.06406149903907751, 62.09817424727762, 0, 837, 48.0, 130.0, 167.0, 256.0, 833.5892130031373, 30803.025498965355, 221.02997129697619], "isController": false}, "titles": ["Label", "#Samples", "FAIL", "Error %", "Average", "Min", "Max", "Median", "90th pct", "95th pct", "99th pct", "Transactions/s", "Received", "Sent"], "items": [{"data": ["get_history_aggregation by_year", 480, 0, 0.0, 47.00208333333336, 1, 307, 31.0, 108.0, 156.84999999999997, 240.08999999999997, 36.25103844120535, 16.957272864587267, 12.779907106713996], "isController": false}, {"data": ["get_balance", 480, 0, 0.0, 68.89166666666672, 5, 320, 56.0, 138.90000000000003, 175.84999999999997, 260.19, 43.35651702646554, 49.36884653599494, 10.796788907957728], "isController": false}, {"data": ["get_balance_history by_time hive", 480, 0, 0.0, 49.162499999999994, 4, 307, 34.0, 111.0, 137.89999999999998, 227.19, 36.41881638846738, 450.61172230652505, 12.021054628224583], "isController": false}, {"data": ["get_balance_history by_time vest", 480, 0, 0.0, 45.137500000000024, 3, 331, 28.0, 101.0, 131.95, 241.70999999999998, 36.6188587122368, 189.35239929813852, 12.122844827586206], "isController": false}, {"data": ["get_btracker_last_synced_block", 480, 0, 0.0, 58.48541666666664, 2, 345, 42.0, 125.0, 171.0, 255.38, 39.005363237445145, 8.875243783520235, 9.218064358849343], "isController": false}, {"data": ["get_transfer_statistics by_month", 480, 0, 0.0, 27.55000000000001, 1, 178, 12.0, 79.80000000000007, 115.94999999999999, 151.19, 32.358096265336385, 52.99270257516516, 10.680699743831738], "isController": false}, {"data": ["get_total_value_locked", 3840, 0, 0.0, 84.56432291666657, 20, 603, 71.0, 153.0, 183.0, 268.59000000000015, 257.6316672257631, 80.25830258302584, 58.87286145588729], "isController": false}, {"data": ["get_history_aggregation by_day", 480, 0, 0.0, 47.541666666666615, 3, 335, 30.0, 112.90000000000003, 154.5499999999999, 235.14, 36.48248080869499, 1579.6130386866307, 12.79024473664209], "isController": false}, {"data": ["get_history_aggregation by_month", 480, 0, 0.0, 44.78333333333339, 2, 339, 27.5, 109.60000000000014, 158.95, 224.38, 36.45754215403311, 82.1006759835941, 12.92391386905666], "isController": false}, {"data": ["GET /top-holders (HBD)", 480, 0, 0.0, 44.549999999999976, 5, 354, 30.0, 102.0, 127.89999999999998, 257.6499999999999, 35.14166483637162, 185.35169119262025, 5.628157258950142], "isController": false}, {"data": ["GET /top-holders (HIVE)", 480, 0, 0.0, 44.608333333333334, 3, 360, 28.0, 101.0, 150.89999999999998, 246.57, 34.94975972040192, 184.8514635211883, 5.631553079947575], "isController": false}, {"data": ["get_delegations", 480, 0, 0.0, 68.39374999999995, 1, 315, 52.0, 137.0, 187.84999999999997, 258.74999999999994, 46.22496147919877, 12.594496340523882, 11.64652349768875], "isController": false}, {"data": ["get_balance_history by_time hbd", 480, 0, 0.0, 43.82500000000001, 3, 465, 26.0, 100.80000000000007, 150.74999999999994, 250.19, 36.672014668805865, 80.86465734586294, 12.068817327526931], "isController": false}, {"data": ["get_recurrent_transfers", 480, 0, 0.0, 73.38750000000002, 7, 338, 59.0, 151.7000000000001, 195.0, 287.22999999999996, 44.399223013597265, 12.790791786143743, 11.186522985847748], "isController": false}, {"data": ["get_transfer_statistics by_hour", 480, 0, 0.0, 92.24583333333321, 33, 837, 70.0, 150.90000000000003, 204.5499999999999, 709.1699999999998, 32.39959500506244, 27042.935791427608, 10.662757340533243], "isController": false}, {"data": ["get_transfer_statistics by_year", 480, 0, 0.0, 30.514583333333366, 1, 302, 14.0, 78.0, 116.79999999999995, 196.76, 32.182366744887695, 14.268354006034194, 10.622695273214886], "isController": false}, {"data": ["get_balance_history by_block hive", 8, 8, 100.0, 71.375, 58, 79, 75.0, 79.0, 79.0, 79.0, 101.26582278481013, 31.25, 29.667721518987342], "isController": false}, {"data": ["GET /top-holders (VESTS)", 480, 0, 0.0, 63.295833333333434, 16, 281, 50.0, 122.90000000000003, 152.74999999999994, 265.76, 35.19061583577713, 213.34310850439883, 5.704728739002932], "isController": false}, {"data": ["get_btracker_version", 480, 0, 0.0, 54.12083333333332, 0, 353, 34.0, 121.7000000000001, 161.95, 264.84999999999997, 39.2349190779794, 10.460090730750368, 8.889161353604708], "isController": false}, {"data": ["get_transfer_statistics by_day", 480, 0, 0.0, 34.3875, 2, 329, 15.0, 100.0, 131.95, 270.0, 32.37774030354131, 1215.524873524452, 10.655564924114671], "isController": false}]}, function(index, item){
        switch(index){
            // Errors pct
            case 3:
                item = item.toFixed(2) + '%';
                break;
            // Mean
            case 4:
            // Mean
            case 7:
            // Median
            case 8:
            // Percentile 1
            case 9:
            // Percentile 2
            case 10:
            // Percentile 3
            case 11:
            // Throughput
            case 12:
            // Kbytes/s
            case 13:
            // Sent Kbytes/s
                item = item.toFixed(2);
                break;
        }
        return item;
    }, [[0, 0]], 0, summaryTableHeader);

    // Create error table
    createTable($("#errorsTable"), {"supportsControllersDiscrimination": false, "titles": ["Type of error", "Number of errors", "% in errors", "% in all samples"], "items": [{"data": ["400/Bad Request", 8, 100.0, 0.06406149903907751], "isController": false}]}, function(index, item){
        switch(index){
            case 2:
            case 3:
                item = item.toFixed(2) + '%';
                break;
        }
        return item;
    }, [[1, 1]]);

        // Create top5 errors by sampler
    createTable($("#top5ErrorsBySamplerTable"), {"supportsControllersDiscrimination": false, "overall": {"data": ["Total", 12488, 8, "400/Bad Request", 8, "", "", "", "", "", "", "", ""], "isController": false}, "titles": ["Sample", "#Samples", "#Errors", "Error", "#Errors", "Error", "#Errors", "Error", "#Errors", "Error", "#Errors", "Error", "#Errors"], "items": [{"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": ["get_balance_history by_block hive", 8, 8, "400/Bad Request", 8, "", "", "", "", "", "", "", ""], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}, {"data": [], "isController": false}]}, function(index, item){
        return item;
    }, [[0, 0]], 0);

});
