type TEmptyReq = {};
export declare enum BtrackerBackendGranularity {
    Daily = "daily",
    Monthly = "monthly",
    Yearly = "yearly"
}
export declare enum BtrackerBackendGranularityHourly {
    Hourly = "hourly",
    Daily = "daily",
    Monthly = "monthly",
    Yearly = "yearly"
}
export declare enum BtrackerBackendNaiType {
    HBD = "HBD",
    HIVE = "HIVE",
    VESTS = "VESTS"
}
export declare enum BtrackerBackendLiquidNaiType {
    HBD = "HBD",
    HIVE = "HIVE"
}
export declare enum BtrackerBackendBalanceType {
    Balance = "balance",
    SavingsBalance = "savings_balance"
}
export declare enum BtrackerBackendSortDirection {
    Asc = "asc",
    Desc = "desc"
}
export interface BtrackerBackendBalance {
    /** number of HIVE backed dollars the account has */
    hbd_balance?: number;
    /** account''s HIVE balance */
    hive_balance?: number;
    /** account''s VEST balance */
    vesting_shares?: string;
    /** the VEST balance, presented in HIVE, is calculated based on the current HIVE price */
    vesting_balance_hive?: number;
    /** account''s VEST balance - delegated VESTs + reveived VESTs, presented in HIVE,calculated based on the current HIVE price */
    post_voting_power_vests?: string;
    /** VESTS delegated to another user, account''s power is lowered by delegated VESTS */
    delegated_vests?: string;
    /** VESTS received from another user, account''s power is increased by received VESTS */
    received_vests?: string;
    /** rewards obtained by posting and commenting expressed in VEST */
    curation_rewards?: string;
    /** curator''s reward expressed in VEST */
    posting_rewards?: string;
    /** not yet claimed HIVE backed dollars stored in hbd reward balance */
    hbd_rewards?: number;
    /** not yet claimed HIVE stored in hive reward balance */
    hive_rewards?: number;
    /** not yet claimed VESTS stored in vest reward balance */
    vests_rewards?: string;
    /** the reward vesting balance, denominated in HIVE, is determined by the prevailing HIVE price at the time of reward reception */
    hive_vesting_rewards?: number;
    /** saving balance of HIVE backed dollars */
    hbd_savings?: number;
    /** HIVE saving balance */
    hive_savings?: number;
    /** number representing how many payouts are pending from user''s saving balance */
    savings_withdraw_requests?: number;
    /** received until the withdrawal is complete, with each installment amounting to 1/13 of the withdrawn total */
    vesting_withdraw_rate?: string;
    /** the remaining total VESTS needed to complete withdrawals */
    to_withdraw?: string;
    /** the total VESTS already withdrawn from active withdrawals */
    withdrawn?: string;
    /** list of account receiving the part of a withdrawal */
    withdraw_routes?: number;
    /** blocked VESTS by a withdrawal */
    delayed_vests?: string;
    /** total HBD currently pending conversion */
    conversion_pending_amount_hbd?: number;
    /** number of HBD conversion requests */
    conversion_pending_count_hbd?: number;
    /** total HIVE currently pending conversion */
    conversion_pending_amount_hive?: number;
    /** number of HIVE conversion requests */
    conversion_pending_count_hive?: number;
    /** count of open HBD orders */
    open_orders_hbd_count?: number;
    /** count of open HIVE orders */
    open_orders_hive_count?: number;
    /** total amount of HIVE in open orders */
    open_orders_hive_amount?: number;
    /** total amount of HBD in open orders */
    open_orders_hbd_amount?: number;
    /** total HBD currently pending transfer */
    savings_pending_amount_hbd?: number;
    /** total HIVE currently pending transfer */
    savings_pending_amount_hive?: number;
    /** total HBD currently locked in escrows (sender-view) */
    escrow_pending_amount_hbd?: number;
    /** total HIVE currently locked in escrows (sender-view) */
    escrow_pending_amount_hive?: number;
    /** number of distinct open escrows (sender-view) */
    escrow_pending_count?: number;
}
export interface BtrackerBackendBalances {
    /** aggregated account''s balance */
    balance?: string;
    /** aggregated account''s savings balance */
    savings_balance?: string;
}
export interface BtrackerBackendAggregatedHistory {
    /**
     * date of the balance aggregation
     * @format date-time
     */
    date?: string;
    /** aggregated account''s balance */
    balance?: BtrackerBackendBalances;
    /** aggregated account''s balance from the previous day/month/year */
    prev_balance?: BtrackerBackendBalances;
    /** minimum account''s balance in the aggregation period */
    min_balance?: BtrackerBackendBalances;
    /** maximum account''s balance in the aggregation period */
    max_balance?: BtrackerBackendBalances;
}
export interface BtrackerBackendBalanceHistory {
    /** block number */
    block_num?: number;
    /** unique operation identifier with an encoded block number and operation type id */
    operation_id?: string;
    /** operation type identifier */
    op_type_id?: number;
    /** The closing balance */
    balance?: string;
    /** Balance in previous day/month/year */
    prev_balance?: string;
    /** Diffrence between balance and prev_balance */
    balance_change?: string;
    /**
     * Creation date
     * @format date-time
     */
    timestamp?: string;
}
export interface BtrackerBackendOperationHistory {
    /** Total number of operations */
    total_operations?: number;
    /** Total number of pages */
    total_pages?: number;
    /** List of operation results */
    operations_result?: BtrackerBackendBalanceHistory[];
}
export interface BtrackerBackendIncomingDelegations {
    /** account name of the delegator */
    delegator?: string;
    /** amount of vests delegated */
    amount?: string;
    /** unique operation identifier with an encoded block number and operation type id */
    operation_id?: string;
    /** block number */
    block_num?: number;
}
export interface BtrackerBackendOutgoingDelegations {
    /** account name of the delegatee */
    delegatee?: string;
    /** amount of vests delegated */
    amount?: string;
    /** unique operation identifier with an encoded block number and operation type id */
    operation_id?: string;
    /** block number */
    block_num?: number;
}
export interface BtrackerBackendDelegations {
    /** List of outgoing delegations from the account */
    outgoing_delegations?: BtrackerBackendOutgoingDelegations[];
    /** List of incoming delegations to the account */
    incoming_delegations?: BtrackerBackendIncomingDelegations[];
}
export interface BtrackerBackendAmount {
    nai?: string;
    amount?: string;
    precision?: number;
}
export interface BtrackerBackendIncomingRecurrentTransfers {
    /** Account name of the sender */
    from?: string;
    /** ID of the pair of accounts */
    pair_id?: number;
    /** Amount of the transfer with NAI and precision */
    amount?: BtrackerBackendAmount;
    /** amount of consecutive failures */
    consecutive_failures?: number;
    /** Remaining executions */
    remaining_executions?: number;
    /** Recurrence in hours */
    recurrence?: number;
    /** Memo message */
    memo?: string;
    /**
     * Date of the next trigger of the transfer
     * @format date-time
     */
    trigger_date?: string;
    /** Unique operation identifier with an encoded block number and operation type id */
    operation_id?: string;
    /** Block number */
    block_num?: number;
}
export interface BtrackerBackendOutgoingRecurrentTransfers {
    /** Account name of the receiver */
    to?: string;
    /** ID of the pair of accounts */
    pair_id?: number;
    /** Amount of the transfer with NAI and precision */
    amount?: BtrackerBackendAmount;
    /** amount of consecutive failures */
    consecutive_failures?: number;
    /** Remaining executions */
    remaining_executions?: number;
    /** Recurrence in hours */
    recurrence?: number;
    /** Memo message */
    memo?: string;
    /**
     * Date of the next trigger of the transfer
     * @format date-time
     */
    trigger_date?: string;
    /** Unique operation identifier with an encoded block number and operation type id */
    operation_id?: string;
    /** Block number */
    block_num?: number;
}
export interface BtrackerBackendRecurrentTransfers {
    /** List of outgoing recurrent transfers from the account */
    outgoing_recurrent_transfers?: BtrackerBackendOutgoingRecurrentTransfers[];
    /** List of incoming recurrent transfers to the account */
    incoming_recurrent_transfers?: BtrackerBackendIncomingRecurrentTransfers[];
}
export interface BtrackerBackendTransferStats {
    /**
     * the time transfers were included in the blockchain
     * @format date-time
     */
    date?: string;
    /** sum of a amount of transfered tokens in the period */
    total_transfer_amount?: string;
    /** average amount of transfered tokens in the period */
    average_transfer_amount?: string;
    /** maximum amount of transfered tokens in the period */
    maximum_transfer_amount?: string;
    /** minimum amount of transfered tokens in the period */
    minimum_transfer_amount?: string;
    /** number of transfers in the period */
    transfer_count?: number;
    /** last block number in time range */
    last_block_num?: number;
}
export type BtrackerBackendArrayOfTransferStats = BtrackerBackendTransferStats[];
export interface BtrackerBackendRankedHolder {
    /** Position in the ranking */
    rank?: number;
    /** Account name */
    account?: string;
    /** Asset balance for that account */
    value?: string;
}
export interface BtrackerBackendTopHolders {
    /** Total number of accounts that match */
    total_accounts?: number;
    /** Total number of pages (given requested page-size) */
    total_pages?: number;
    /** Ranked holders for the requested page */
    holders_result?: BtrackerBackendRankedHolder[];
}
export interface BtrackerBackendTotalValueLocked {
    /** Head block number at which the snapshot was computed */
    block_num?: number;
    /** Global sum of VESTS */
    total_vests?: string;
    /** Total number of HIVE in savings */
    savings_hive?: string;
    /** Total number of HIVE backed dollars the chain has in savings */
    savings_hbd?: string;
}
export type BtrackerBackendArrayOfAggregatedHistory = BtrackerBackendAggregatedHistory[];
export interface BtrackerEndpointsGetBalanceHistoryParams {
    /**
     * Coin types:
     *
     * * HBD
     *
     * * HIVE
     *
     * * VESTS
     */
    "coin-type": BtrackerBackendNaiType;
    /**
     * Balance types:
     *
     * * balance
     *
     * * savings_balance
     * @default "balance"
     */
    "balance-type"?: BtrackerBackendBalanceType;
    /**
     * Return page on `page` number, default null due to reversed order of pages,
     * the first page is the oldest,
     * example: first call returns the newest page and total_pages is 100 - the newest page is number 100, next 99 etc.
     * @default null
     */
    page?: number;
    /**
     * Return max `page-size` operations per page, defaults to `100`
     * @default 100
     */
    "page-size"?: number;
    /**
     * Sort order:
     *
     *  * `asc` - Ascending, from oldest to newest
     *
     *  * `desc` - Descending, from newest to oldest
     * @default "desc"
     */
    direction?: BtrackerBackendSortDirection;
    /**
     * Lower limit of the block range, can be represented either by a block-number (integer) or a timestamp (in the format YYYY-MM-DD HH:MI:SS).
     *
     * The provided `timestamp` will be converted to a `block-num` by finding the first block
     * where the block''s `created_at` is more than or equal to the given `timestamp` (i.e. `block''s created_at >= timestamp`).
     *
     * The function will interpret and convert the input based on its format, example input:
     *
     * * `2016-09-15 19:47:21`
     *
     * * `5000000`
     * @default null
     */
    "from-block"?: string;
    /**
     * Similar to the from-block parameter, can either be a block-number (integer) or a timestamp (formatted as YYYY-MM-DD HH:MI:SS).
     *
     * The provided `timestamp` will be converted to a `block-num` by finding the first block
     * where the block''s `created_at` is less than or equal to the given `timestamp` (i.e. `block''s created_at <= timestamp`).
     *
     * The function will convert the value depending on its format, example input:
     *
     * * `2016-09-15 19:47:21`
     *
     * * `5000000`
     * @default null
     */
    "to-block"?: string;
    /** Name of the account */
    accountName: string;
}
export interface BtrackerEndpointsGetBalanceAggregationParams {
    /**
     * Coin types:
     *
     * * HBD
     *
     * * HIVE
     *
     * * VESTS
     */
    "coin-type": BtrackerBackendNaiType;
    /**
     * granularity types:
     *
     * * daily
     *
     * * monthly
     *
     * * yearly
     * @default "yearly"
     */
    granularity?: BtrackerBackendGranularity;
    /**
     * Sort order:
     *
     *  * `asc` - Ascending, from oldest to newest
     *
     *  * `desc` - Descending, from newest to oldest
     * @default "desc"
     */
    direction?: BtrackerBackendSortDirection;
    /**
     * Lower limit of the block range, can be represented either by a block-number (integer) or a timestamp (in the format YYYY-MM-DD HH:MI:SS).
     *
     * The provided `timestamp` will be converted to a `block-num` by finding the first block
     * where the block''s `created_at` is more than or equal to the given `timestamp` (i.e. `block''s created_at >= timestamp`).
     *
     * The function will interpret and convert the input based on its format, example input:
     *
     * * `2016-09-15 19:47:21`
     *
     * * `5000000`
     * @default null
     */
    "from-block"?: string;
    /**
     * Similar to the from-block parameter, can either be a block-number (integer) or a timestamp (formatted as YYYY-MM-DD HH:MI:SS).
     *
     * The provided `timestamp` will be converted to a `block-num` by finding the first block
     * where the block''s `created_at` is less than or equal to the given `timestamp` (i.e. `block''s created_at <= timestamp`).
     *
     * The function will convert the value depending on its format, example input:
     *
     * * `2016-09-15 19:47:21`
     *
     * * `5000000`
     * @default null
     */
    "to-block"?: string;
    /** Name of the account */
    accountName: string;
}
export interface BtrackerEndpointsGetTopHoldersParams {
    /**
     * * HBD
     * * HIVE
     * * VESTS
     */
    "coin-type": BtrackerBackendNaiType;
    /**
     * `balance` or `savings_balance`
     * (`savings_balance` not allowed with `VESTS`).
     * @default "balance"
     */
    "balance-type"?: BtrackerBackendBalanceType;
    /**
     * 1-based page number.
     * @min 1
     * @default 1
     */
    page?: number;
    /**
     * Max results per page (capped by backend validator).
     * @min 1
     * @default 100
     */
    "page-size"?: number;
}
export interface BtrackerEndpointsGetTransferStatisticsParams {
    /**
     * Coin types:
     *
     * * HBD
     *
     * * HIVE
     */
    "coin-type": BtrackerBackendLiquidNaiType;
    /**
     * granularity types:
     *
     * * hourly
     *
     * * daily
     *
     * * monthly
     *
     * * yearly
     * @default "yearly"
     */
    granularity?: BtrackerBackendGranularityHourly;
    /**
     * Sort order:
     *
     *  * `asc` - Ascending, from oldest to newest
     *
     *  * `desc` - Descending, from newest to oldest
     * @default "desc"
     */
    direction?: BtrackerBackendSortDirection;
    /**
     * Lower limit of the block range, can be represented either by a block-number (integer) or a timestamp (in the format YYYY-MM-DD HH:MI:SS).
     *
     * The provided `timestamp` will be converted to a `block-num` by finding the first block
     * where the block''s `created_at` is more than or equal to the given `timestamp` (i.e. `block''s created_at >= timestamp`).
     *
     * The function will interpret and convert the input based on its format, example input:
     *
     * * `2016-09-15 19:47:21`
     *
     * * `5000000`
     * @default null
     */
    "from-block"?: string;
    /**
     * Similar to the from-block parameter, can either be a block-number (integer) or a timestamp (formatted as YYYY-MM-DD HH:MI:SS).
     *
     * The provided `timestamp` will be converted to a `block-num` by finding the first block
     * where the block''s `created_at` is less than or equal to the given `timestamp` (i.e. `block''s created_at <= timestamp`).
     *
     * The function will convert the value depending on its format, example input:
     *
     * * `2016-09-15 19:47:21`
     *
     * * `5000000`
     * @default null
     */
    "to-block"?: string;
}
declare const _default: {
    balance_tracker: {
        accounts: {
            accountName: {
                balances: {
                    result: BtrackerBackendBalance;
                    params: TEmptyReq & TEmptyReq & {
                        /** Name of the account */
                        accountName: string;
                    };
                };
                balanceHistory: {
                    result: BtrackerBackendOperationHistory;
                    params: BtrackerEndpointsGetBalanceHistoryParams & TEmptyReq & {
                        /** Name of the account */
                        accountName: string;
                    };
                };
                aggregatedHistory: {
                    result: BtrackerBackendArrayOfAggregatedHistory;
                    params: BtrackerEndpointsGetBalanceAggregationParams & TEmptyReq & {
                        /** Name of the account */
                        accountName: string;
                    };
                };
                delegations: {
                    result: BtrackerBackendDelegations;
                    params: TEmptyReq & TEmptyReq & {
                        /** Name of the account */
                        accountName: string;
                    };
                };
                recurrentTransfers: {
                    result: BtrackerBackendRecurrentTransfers;
                    params: TEmptyReq & TEmptyReq & {
                        /** Name of the account */
                        accountName: string;
                    };
                };
            };
        };
        topHolders: {
            result: BtrackerBackendTopHolders;
            params: BtrackerEndpointsGetTopHoldersParams & TEmptyReq & {};
        };
        transferStatistics: {
            result: BtrackerBackendArrayOfTransferStats;
            params: BtrackerEndpointsGetTransferStatisticsParams & TEmptyReq & {};
        };
        version: {
            result: string;
            params: undefined;
        };
        lastSyncedBlock: {
            result: number;
            params: undefined;
        };
        totalValueLocked: {
            result: BtrackerBackendTotalValueLocked;
            params: undefined;
        };
    };
};
export default _default;
