export var BtrackerBackendGranularity;
(function (BtrackerBackendGranularity) {
    BtrackerBackendGranularity["Daily"] = "daily";
    BtrackerBackendGranularity["Monthly"] = "monthly";
    BtrackerBackendGranularity["Yearly"] = "yearly";
})(BtrackerBackendGranularity || (BtrackerBackendGranularity = {}));
export var BtrackerBackendGranularityHourly;
(function (BtrackerBackendGranularityHourly) {
    BtrackerBackendGranularityHourly["Hourly"] = "hourly";
    BtrackerBackendGranularityHourly["Daily"] = "daily";
    BtrackerBackendGranularityHourly["Monthly"] = "monthly";
    BtrackerBackendGranularityHourly["Yearly"] = "yearly";
})(BtrackerBackendGranularityHourly || (BtrackerBackendGranularityHourly = {}));
export var BtrackerBackendNaiType;
(function (BtrackerBackendNaiType) {
    BtrackerBackendNaiType["HBD"] = "HBD";
    BtrackerBackendNaiType["HIVE"] = "HIVE";
    BtrackerBackendNaiType["VESTS"] = "VESTS";
})(BtrackerBackendNaiType || (BtrackerBackendNaiType = {}));
export var BtrackerBackendLiquidNaiType;
(function (BtrackerBackendLiquidNaiType) {
    BtrackerBackendLiquidNaiType["HBD"] = "HBD";
    BtrackerBackendLiquidNaiType["HIVE"] = "HIVE";
})(BtrackerBackendLiquidNaiType || (BtrackerBackendLiquidNaiType = {}));
export var BtrackerBackendBalanceType;
(function (BtrackerBackendBalanceType) {
    BtrackerBackendBalanceType["Balance"] = "balance";
    BtrackerBackendBalanceType["SavingsBalance"] = "savings_balance";
})(BtrackerBackendBalanceType || (BtrackerBackendBalanceType = {}));
export var BtrackerBackendSortDirection;
(function (BtrackerBackendSortDirection) {
    BtrackerBackendSortDirection["Asc"] = "asc";
    BtrackerBackendSortDirection["Desc"] = "desc";
})(BtrackerBackendSortDirection || (BtrackerBackendSortDirection = {}));
export default {
    balance_tracker: {
        accounts: {
            urlPath: "accounts",
            accountName: {
                urlPath: "{accountName}",
                balances: {
                    urlPath: "balances",
                    method: "GET"
                },
                balanceHistory: {
                    urlPath: "balance-history",
                    method: "GET"
                },
                aggregatedHistory: {
                    urlPath: "aggregated-history",
                    method: "GET"
                },
                delegations: {
                    urlPath: "delegations",
                    method: "GET"
                },
                recurrentTransfers: {
                    urlPath: "recurrent-transfers",
                    method: "GET"
                }
            }
        },
        topHolders: {
            urlPath: "top-holders",
            method: "GET"
        },
        transferStatistics: {
            urlPath: "transfer-statistics",
            method: "GET"
        },
        version: {
            urlPath: "version",
            method: "GET"
        },
        lastSyncedBlock: {
            urlPath: "last-synced-block",
            method: "GET"
        },
        totalValueLocked: {
            urlPath: "total-value-locked",
            method: "GET"
        }
    },
    urlPath: "balance_tracker"
};
