import React from "react";
import ErrorUI from "./ErrorUI/ErrorUI";

class ErrorBoundary extends React.Component {
  constructor(props) {
    super(props);
    this.state = { hasError: false };
  }
  static getDerivedStateFromError(error) {
    // Update state so the next render will show the fallback UI.
    return { hasError: true };
  }

  render() {
    if (this.state.hasError) {
      // You can render any custom fallback UI
      return <ErrorUI />;
    }
    return this.props.children;
  }
}

export default ErrorBoundary;
