import { useState } from "react";
import {
  KeychainKeyTypes,
  KeychainRequestResponse,
  KeychainSDK,
} from "keychain-sdk";
import {
  ApiOperation,
  createHiveChain,
  TTransactionPackType,
} from "@hiveio/wax";
import "./App.css";

const keychainSDK = new KeychainSDK(window);
const hiveChain = createHiveChain({
  apiEndpoint: "https://api.hive.blog",
});

async function createTxAndRequestSignature() {
  try {
    const tx = await (await hiveChain).createTransaction();

    tx.pushOperation({
      vote: {
        voter: "testhiveuserauto",
        author: "testhiveuserauto",
        permlink: "test",
        weight: 100,
      },
    });

    tx.pushOperation({
      transfer: {
        from_account: "testhiveuserauto",
        to_account: "testhiveuserauto",
        amount: (await hiveChain).hiveCoins(1),
        memo: "test",
      },
    });
    /**
     * try with sign buffer
     */
    const signBufferResult = await keychainSDK.signBuffer({
      method: KeychainKeyTypes.posting,
      message: tx.sigDigest,
      username: "testhiveuserauto",
    });

    console.log(signBufferResult);

    const signatureFromBuffer = signBufferResult.result?.toString();

    if (!signatureFromBuffer) {
      throw new Error("No signature from buffer");
    }

    tx.sign(signatureFromBuffer);

    // Try to verify the signature

    //const verifyAuthorityFromBuffer = await (
    //  await hiveChain
    //).api.database_api.verify_authority({
    //  trx: tx.toApiJson(),
    //  pack: TTransactionPackType.LEGACY,
    //});

    //console.log(verifyAuthorityFromBuffer);

    //////
    /// Try with cloned tx
    const clonedTx = (await hiveChain).createTransactionFromJson(
      tx.toApiJson()
    );

    console.log("clonedTx", clonedTx.transaction.operations);
    // ! This is unsense
    const mappedOperations = clonedTx.transaction.operations.map((op) => [
      Object.keys(op).filter(
        (key) => op[key as keyof typeof op] !== undefined
      )[0],
      Object.values(op).filter((value) => value !== undefined)[0],
    ]);

    console.log("mappedOperations", mappedOperations);
    /**
     * try with tx converted to legacy api
     */
    const signingResult = await keychainSDK.signTx({
      method: KeychainKeyTypes.posting,
      tx: {
        expiration: clonedTx.transaction.expiration,
        ref_block_num: clonedTx.transaction.ref_block_num,
        ref_block_prefix: clonedTx.transaction.ref_block_prefix,
        // operations: tx.transaction.operations, // <--- this is the issue
        operations: mappedOperations as any[], // wont work either
        extensions: clonedTx.transaction.extensions,
      },
      username: "testhiveuserauto",
    });

    // Get signed tx with legacy Ops
    const legacyTx = signingResult.result;
    console.log("legacyTx", legacyTx);

    const verifyAuthority = await (
      await hiveChain
    ).api.database_api.verify_authority({
      trx: {
        ...legacyTx,
        operations: legacyTx.operations.map((op) => ({
          type: `${op[0]}_operation`,
          value: op[1],
        })) as ApiOperation[], // This cast back doesnt work, either.
      },
      pack: TTransactionPackType.HF_26,
    });

    console.log(verifyAuthority);

    return verifyAuthority;
  } catch (error) {
    console.error(error);
  }
}

function App() {
  return (
    <>
      <h1>web3 app</h1>
      <div>
        <pre>
          {JSON.stringify({
            voter: "testhiveuserauto",
            author: "testhiveuserauto",
            permlink: "test",
            weight: 100,
          })}
        </pre>
        <button onClick={() => createTxAndRequestSignature()}>
          create tx and request signature from keychain
        </button>
      </div>
    </>
  );
}

export default App;
